/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.introspector.extension;

import com.mulesoft.runtime.ang.introspector.extension.MuleArtifactResourcesRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.boot.ExtensionLoaderUtils;
import org.mule.runtime.deployment.model.api.artifact.extension.ExtensionDiscoveryRequest;
import org.mule.runtime.deployment.model.api.artifact.extension.ExtensionModelDiscoverer;
import org.mule.runtime.deployment.model.api.artifact.extension.ExtensionModelLoaderRepository;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExtensionModelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionModelService.class);
    private final ExtensionModelDiscoverer extensionModelDiscoverer = new ExtensionModelDiscoverer();
    private final MuleArtifactResourcesRegistry muleArtifactResourcesRegistry;
    private final Set<ExtensionModel> runtimeExtensionModels;

    public DefaultExtensionModelService(MuleArtifactResourcesRegistry muleArtifactResourcesRegistry, Set<ExtensionModel> runtimeExtensionModels) {
        Objects.requireNonNull(muleArtifactResourcesRegistry, "muleArtifactResourcesRegistry cannot be null");
        this.muleArtifactResourcesRegistry = muleArtifactResourcesRegistry;
        this.runtimeExtensionModels = Collections.unmodifiableSet(runtimeExtensionModels);
    }

    public Set<ExtensionModel> loadExtensionsData(List<ArtifactClassLoader> artifactPluginClassLoaders) {
        ExtensionModelLoaderRepository extensionModelLoaderRepository = null;
        try {
            extensionModelLoaderRepository = ExtensionModelLoaderRepository.getExtensionModelLoaderManager((ArtifactClassLoader)this.muleArtifactResourcesRegistry.getContainerArtifactClassLoader(), () -> ExtensionLoaderUtils.lookupExtensionModelLoaders().collect(Collectors.toSet()));
            LifecycleUtils.startIfNeeded((Object)extensionModelLoaderRepository);
            Set<ExtensionModel> set = this.getLoadedExtensionsInformation(artifactPluginClassLoaders, extensionModelLoaderRepository);
            return set;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        finally {
            if (extensionModelLoaderRepository != null) {
                try {
                    LifecycleUtils.stopIfNeeded((Object)extensionModelLoaderRepository);
                }
                catch (MuleException e) {
                    LOGGER.error("Exception stopping extensionModelLoaderRepository: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private Set<ExtensionModel> getLoadedExtensionsInformation(List<ArtifactClassLoader> artifactPluginClassLoaders, ExtensionModelLoaderRepository loaderRepository) {
        return this.extensionModelDiscoverer.discoverPluginsExtensionModels(ExtensionDiscoveryRequest.builder().setLoaderRepository(loaderRepository).setArtifactPlugins(artifactPluginClassLoaders.stream().map(plugincl -> new Pair((Object)((ArtifactPluginDescriptor)plugincl.getArtifactDescriptor()), plugincl)).collect(Collectors.toList())).setParentArtifactExtensions(this.runtimeExtensionModels).setParallelDiscovery(true).setEnrichDescriptions(false).build()).stream().map(Pair::getSecond).collect(Collectors.toSet());
    }
}

