/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.introspector.extension.application;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.builder.ApplicationClassLoaderBuilder;
import org.mule.runtime.deployment.model.api.builder.ApplicationClassLoaderBuilderFactory;
import org.mule.runtime.deployment.model.api.builder.DeployableArtifactClassLoaderFactoryProvider;
import org.mule.runtime.deployment.model.api.builder.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class ApplicationClassLoaderFactory {
    private final ArtifactClassLoader containerArtifactClassLoader;
    private final RegionPluginClassLoadersFactory regionPluginClassLoadersFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;

    public ApplicationClassLoaderFactory(ArtifactClassLoader containerArtifactClassLoader, RegionPluginClassLoadersFactory regionPluginClassLoadersFactory, PluginDependenciesResolver pluginDependenciesResolver) {
        Objects.requireNonNull(containerArtifactClassLoader, "containerArtifactClassLoader cannot be null");
        Objects.requireNonNull(regionPluginClassLoadersFactory, "regionPluginClassLoadersFactory cannot be null");
        Objects.requireNonNull(pluginDependenciesResolver, "pluginDependenciesResolver cannot be null");
        this.containerArtifactClassLoader = containerArtifactClassLoader;
        this.regionPluginClassLoadersFactory = regionPluginClassLoadersFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
    }

    public MuleDeployableArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor applicationDescriptor, File workingDirectory) {
        try {
            ApplicationClassLoaderBuilder builder = new ApplicationClassLoaderBuilderFactory(DeployableArtifactClassLoaderFactoryProvider.applicationClassLoaderFactory(name -> new File(workingDirectory, (String)name)), this.regionPluginClassLoadersFactory).createArtifactClassLoaderBuilder();
            HashSet domainPluginDescriptors = new HashSet();
            boolean hasDomainDependency = applicationDescriptor.getDomainDescriptor().isPresent();
            if (hasDomainDependency) {
                throw new UnsupportedOperationException("Apps depending on domains are not yet supported");
            }
            builder.setDomainParentClassLoader(this.containerArtifactClassLoader);
            this.pluginDependenciesResolver.resolve(domainPluginDescriptors, new ArrayList(applicationDescriptor.getPlugins()), true).stream().forEach(xva$0 -> builder.addArtifactPluginDescriptors(new ArtifactPluginDescriptor[]{xva$0}));
            builder.setArtifactDescriptor((ArtifactDescriptor)applicationDescriptor);
            return builder.build();
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

