/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.introspector.extractor;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.internal.dsl.DslConstants;

public class ConfigPropertiesDataExtractor {
    private static final String NAME_PARAM = "name";
    private static final String VALUE_PARAM = "value";
    public static final String CONFIG_PROPERTIES_KEY = "config-properties";
    private static final String TYPE_KEY = "type";
    private static final String DEFAULT_KEY = "default";
    private static final ComponentIdentifier GLOBAL_PROPERTY_IDENTIFIER = ComponentIdentifier.builder().name("global-property").namespace("mule").namespaceUri(DslConstants.CORE_NAMESPACE).build();
    private static final Pattern CONFIG_PROPERTY_USAGE = Pattern.compile("(?<!\\\\)\\$\\{([^}]+)}");

    public Map<String, Object> extractFrom(ArtifactAst artifact) {
        LinkedHashMap<String, Object> configPropertiesMap = new LinkedHashMap<String, Object>();
        artifact.recursiveStream().forEach(c -> this.extractConfigPropertiesFrom((ComponentAst)c, (Map<String, Object>)configPropertiesMap, this.obtainDefaultValues(artifact)));
        return configPropertiesMap;
    }

    private Map<String, String> obtainDefaultValues(ArtifactAst artifact) {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        artifact.topLevelComponentsStream().filter(c -> c.getIdentifier().equals(GLOBAL_PROPERTY_IDENTIFIER)).forEach(c -> {
            ComponentParameterAst valueParam = c.getParameter("General", VALUE_PARAM);
            if (valueParam.getRawValue() != null) {
                ComponentParameterAst nameParam = c.getParameter("General", NAME_PARAM);
                defaultValues.put(nameParam.getRawValue(), valueParam.getRawValue());
            }
        });
        return defaultValues;
    }

    private void extractConfigPropertiesFrom(ComponentAst component, Map<String, Object> configPropertiesMap, Map<String, String> defaultValues) {
        component.getParameters().stream().filter(p -> p.getRawValue() != null).forEach(p -> {
            this.findPropertyUsages(p.getRawValue(), propName -> {
                LinkedHashMap<Object, Object> configPropertyMap = new LinkedHashMap<Object, Object>();
                this.populateDataType((ComponentParameterAst)p, (Map<Object, Object>)configPropertyMap);
                if (defaultValues.containsKey(propName)) {
                    configPropertyMap.put(DEFAULT_KEY, defaultValues.get(propName));
                } else if (p.getModel().getDefaultValue() != null) {
                    configPropertyMap.put(DEFAULT_KEY, p.getModel().getDefaultValue().toString());
                }
                configPropertiesMap.putIfAbsent((String)propName, configPropertyMap);
            });
            MuleAstUtils.doOnParamComponents((ComponentParameterAst)p, c -> this.extractConfigPropertiesFrom((ComponentAst)c, configPropertiesMap, defaultValues));
        });
    }

    void findPropertyUsages(String rawValue, Consumer<String> onProperty) {
        Matcher matcher = CONFIG_PROPERTY_USAGE.matcher(rawValue);
        while (matcher.find()) {
            onProperty.accept(matcher.group(1));
        }
    }

    private void populateDataType(ComponentParameterAst p, final Map<Object, Object> configPropertyMap) {
        p.getModel().getType().accept(new MetadataTypeVisitor(){

            public void visitBinaryType(BinaryType binaryType) {
                configPropertyMap.put(ConfigPropertiesDataExtractor.TYPE_KEY, "binary");
            }

            public void visitBoolean(BooleanType booleanType) {
                configPropertyMap.put(ConfigPropertiesDataExtractor.TYPE_KEY, "boolean");
            }

            public void visitDateTime(DateTimeType dateTimeType) {
                configPropertyMap.put(ConfigPropertiesDataExtractor.TYPE_KEY, "dateTime");
            }

            public void visitDate(DateType dateType) {
                configPropertyMap.put(ConfigPropertiesDataExtractor.TYPE_KEY, "date");
            }

            public void visitNull(NullType nullType) {
                configPropertyMap.put(ConfigPropertiesDataExtractor.TYPE_KEY, "null");
            }

            public void visitVoid(VoidType voidType) {
                configPropertyMap.put(ConfigPropertiesDataExtractor.TYPE_KEY, "void");
            }

            public void visitNumber(NumberType numberType) {
                configPropertyMap.put(ConfigPropertiesDataExtractor.TYPE_KEY, "number");
            }

            public void visitString(StringType stringType) {
                Optional annotation = stringType.getAnnotation(EnumAnnotation.class);
                if (annotation.isPresent()) {
                    configPropertyMap.put(ConfigPropertiesDataExtractor.TYPE_KEY, "enum");
                    configPropertyMap.put("values", ((EnumAnnotation)annotation.get()).getValues());
                } else {
                    configPropertyMap.put(ConfigPropertiesDataExtractor.TYPE_KEY, "string");
                }
            }

            public void visitTime(TimeType timeType) {
                configPropertyMap.put(ConfigPropertiesDataExtractor.TYPE_KEY, "time");
            }

            public void visitObject(ObjectType objectType) {
                configPropertyMap.put(ConfigPropertiesDataExtractor.TYPE_KEY, "object");
            }

            public void visitArrayType(ArrayType arrayType) {
                configPropertyMap.put(ConfigPropertiesDataExtractor.TYPE_KEY, "array");
            }

            protected void defaultVisit(MetadataType metadataType) {
                configPropertyMap.put(ConfigPropertiesDataExtractor.TYPE_KEY, "other");
            }
        });
    }
}

