/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.introspector.extractor;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.internal.dsl.DslConstants;

public class SchedulersDataExtractor {
    private static final String DESCRIPTION_DOC_PARAM = "description";
    private static final String MAX_CONCURRENCY_PARAM = "maxConcurrency";
    private static final String SCHEDULING_STRATEGY_PARAM = "schedulingStrategy";
    private static final String FIXED_FREQUENCY_SCH_PARAM_VALUE = "fixed-frequency";
    private static final String START_DELAY_PARAM = "startDelay";
    private static final String FREQUENCY_PARAM = "frequency";
    private static final String TIME_UNIT_PARAM = "timeUnit";
    private static final String CRON_SCH_PARAM_VALUE = "cron";
    private static final String CRON_EXPRESSION_PARAM = "expression";
    private static final String TIME_ZONE_PARAM = "timeZone";
    public static final String SCHEDULERS_KEY = "schedulers";
    private static final String SCHEDULER_KEY = "scheduler";
    private static final String STRATEGY_KEY = "strategy";
    private static final String FIXED_FREQUENCY_KEY = "fixedFrequency";
    private static final String TIME_UNIT_KEY = "timeUnit";
    private static final String START_DELAY_KEY = "startDelay";
    private static final String CRON_EXPRESSION_KEY = "cronExpression";
    private static final String TIME_ZONE_KEY = "timeZone";
    private static final ComponentIdentifier CRON_IDENTIFIER = ComponentIdentifier.builder().namespaceUri(DslConstants.CORE_NAMESPACE).namespace("mule").name("cron").build();
    private static final ComponentIdentifier FIXED_FREQUENCY_IDENTIFIER = ComponentIdentifier.builder().namespaceUri(DslConstants.CORE_NAMESPACE).namespace("mule").name("fixed-frequency").build();
    private final Map<ComponentIdentifier, Function<ComponentAst, Map<String, String>>> schedulerExtractors = new HashMap<ComponentIdentifier, Function<ComponentAst, Map<String, String>>>();

    public SchedulersDataExtractor() {
        this.schedulerExtractors.put(FIXED_FREQUENCY_IDENTIFIER, this::extractFixedFrequencyStrategyParameters);
        this.schedulerExtractors.put(CRON_IDENTIFIER, this::extractCronStrategyParameters);
    }

    public Map<String, Object> extractFrom(ArtifactAst artifact) {
        LinkedHashMap<String, Object> schedulersMap = new LinkedHashMap<String, Object>();
        artifact.topLevelComponentsStream().filter(comp -> comp.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.FLOW)).forEach(flow -> flow.directChildrenStream().filter(comp -> comp.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.SOURCE)).filter(src -> src.getParameter("General", SCHEDULING_STRATEGY_PARAM) != null).forEach(src -> schedulersMap.put((String)flow.getComponentId().get(), this.extractFlowScheduler((ComponentAst)flow, (ComponentAst)src))));
        return schedulersMap;
    }

    public Map<String, Object> extractFlowScheduler(ComponentAst flow, ComponentAst src) {
        LinkedHashMap<String, Object> flowOut = new LinkedHashMap<String, Object>();
        Map docAttributes = flow.getMetadata().getDocAttributes();
        if (docAttributes.containsKey(DESCRIPTION_DOC_PARAM)) {
            flowOut.put(DESCRIPTION_DOC_PARAM, docAttributes.get(DESCRIPTION_DOC_PARAM));
        }
        this.putIfPresent(flowOut, MAX_CONCURRENCY_PARAM, flow.getParameter("General", MAX_CONCURRENCY_PARAM));
        src.getParameter("General", SCHEDULING_STRATEGY_PARAM).getValue().mapRight(sch -> {
            ComponentAst scheduler = (ComponentAst)sch;
            if (this.schedulerExtractors.containsKey(scheduler.getIdentifier())) {
                return this.schedulerExtractors.get(scheduler.getIdentifier()).apply(scheduler);
            }
            return Collections.emptyMap();
        }).applyRight(schedulerOut -> flowOut.put(SCHEDULER_KEY, schedulerOut));
        return flowOut;
    }

    private Map<String, String> extractFixedFrequencyStrategyParameters(ComponentAst scheduler) {
        LinkedHashMap<String, String> schedulerOut = new LinkedHashMap<String, String>();
        schedulerOut.put(STRATEGY_KEY, FIXED_FREQUENCY_KEY);
        this.putIfPresent(schedulerOut, "timeUnit", scheduler.getParameter(FIXED_FREQUENCY_SCH_PARAM_VALUE, "timeUnit"));
        this.putIfPresent(schedulerOut, FIXED_FREQUENCY_KEY, scheduler.getParameter(FIXED_FREQUENCY_SCH_PARAM_VALUE, FREQUENCY_PARAM));
        this.putIfPresent(schedulerOut, "startDelay", scheduler.getParameter(FIXED_FREQUENCY_SCH_PARAM_VALUE, "startDelay"));
        return schedulerOut;
    }

    private Map<String, String> extractCronStrategyParameters(ComponentAst scheduler) {
        LinkedHashMap<String, String> schedulerOut = new LinkedHashMap<String, String>();
        schedulerOut.put(STRATEGY_KEY, CRON_SCH_PARAM_VALUE);
        this.putIfPresent(schedulerOut, CRON_EXPRESSION_KEY, scheduler.getParameter(CRON_SCH_PARAM_VALUE, CRON_EXPRESSION_PARAM));
        this.putIfPresent(schedulerOut, "timeZone", scheduler.getParameter(CRON_SCH_PARAM_VALUE, "timeZone"));
        return schedulerOut;
    }

    private <T> void putIfPresent(Map<String, T> out, String outParamName, ComponentParameterAst param) {
        if (param.getRawValue() != null) {
            out.put(outParamName, param.getRawValue());
        } else if (param.getModel().getDefaultValue() != null) {
            out.put(outParamName, param.getModel().getDefaultValue());
        }
    }
}

