/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool;

import com.mulesoft.runtime.upgrade.tool.command.ExecutionExceptionHandler;
import com.mulesoft.runtime.upgrade.tool.command.ExitCodeExceptionMapper;
import com.mulesoft.runtime.upgrade.tool.command.ParameterExceptionHandler;
import com.mulesoft.runtime.upgrade.tool.command.TopCommand;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import picocli.CommandLine;
import picocli.CommandLine.IFactory;

/**
 * Main class of the tool.
 *
 * This class tries to execute the arguments received by the command line. In case that everything is ok, executes the commands
 * correctly, but in case of error, throws an specific exception.
 */
@SpringBootApplication
public class MuleRuntimeUpgradeToolApplication implements CommandLineRunner, ExitCodeGenerator {

  @Autowired
  private IFactory factory;

  @Autowired
  private TopCommand topCommand;

  @Autowired
  private ExecutionExceptionHandler executionExceptionHandler;

  @Autowired
  private ExitCodeExceptionMapper exitCodeExceptionMapper;

  @Autowired
  private ParameterExceptionHandler parameterExceptionHandler;

  private int exitCode;

  @Override
  public void run(String... args) {
    // @todo[question]: Should the app be worried about handling signals, like SIGINT [CTRL-C]?
    exitCode = new CommandLine(topCommand, factory)
        .setAbbreviatedOptionsAllowed(true)
        .setAbbreviatedSubcommandsAllowed(true)
        .setUnmatchedArgumentsAllowed(true)
        .setExecutionExceptionHandler(executionExceptionHandler)
        .setParameterExceptionHandler(parameterExceptionHandler)
        .setExitCodeExceptionMapper(exitCodeExceptionMapper)
        .execute(args);
  }

  @Override
  public int getExitCode() {
    return exitCode;
  }

  public static void main(String[] args) {
    System.exit(SpringApplication.exit(SpringApplication.run(MuleRuntimeUpgradeToolApplication.class, args)));
  }

}
