/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.runtime.upgrade.tool.domain;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * File Descriptor Entity.
 */
@JsonNaming(PropertyNamingStrategies.KebabCaseStrategy.class)
public class AssemblyEntry {

  private String name;
  private long sizeInBytes;
  private String sha256;

  public AssemblyEntry(String name, long sizeInBytes, String sha256) {
    this.name = name;
    this.sizeInBytes = sizeInBytes;
    this.sha256 = sha256;
  }

  public AssemblyEntry() {}

  public String getName() {
    return name;
  }

  public long getSizeInBytes() {
    return sizeInBytes;
  }

  public String getSha256() {
    return sha256;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    final AssemblyEntry other = (AssemblyEntry) obj;
    if (!this.name.equals(other.getName()) || this.sizeInBytes != other.getSizeInBytes()
        || !this.sha256.equals(other.getSha256()))
      return false;
    return true;
  }
}
