/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.domain;

import java.time.Instant;

/**
 * This class provides information about the backup generated after executing the tool.
 */
public class BackupDescriptor {

  private Instant backupGenerationTimestamp;

  private String upgradeToolVersion;

  private String muleRuntimeDistributionVersion;

  public static Builder builder() {
    return new Builder();
  }

  public BackupDescriptor() {}

  protected BackupDescriptor(Instant backupGenerationTimestamp, String upgradeToolVersion,
                             String muleRuntimeDistributionVersion) {
    this.backupGenerationTimestamp = backupGenerationTimestamp;
    this.upgradeToolVersion = upgradeToolVersion;
    this.muleRuntimeDistributionVersion = muleRuntimeDistributionVersion;
  }

  public Instant getBackupGenerationTimestamp() {
    return backupGenerationTimestamp;
  }

  public String getUpgradeToolVersion() {
    return upgradeToolVersion;
  }

  public String getMuleRuntimeDistributionVersion() {
    return muleRuntimeDistributionVersion;
  }

  public static class Builder {

    private Instant backupGenerationTimestamp;
    private String upgradeToolVersion;
    private String muleRuntimeDistributionVersion;

    public Builder backupGenerationTimestamp(Instant backupGenerationTimestamp) {
      this.backupGenerationTimestamp = backupGenerationTimestamp;
      return this;
    }

    public Builder upgradeToolVersion(String upgradeToolVersion) {
      this.upgradeToolVersion = upgradeToolVersion;
      return this;
    }

    public Builder muleRuntimeDistributionVersion(String muleRuntimeDistributionVersion) {
      this.muleRuntimeDistributionVersion = muleRuntimeDistributionVersion;
      return this;
    }

    public BackupDescriptor build() {
      return new BackupDescriptor(backupGenerationTimestamp, upgradeToolVersion, muleRuntimeDistributionVersion);
    }
  }

}
