/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.domain;

/**
 * A class that encapsulates all config options for the upgrade process.
 */
public class UpgradeOptions {

  boolean force;

  public UpgradeOptions() {}

  public UpgradeOptions(boolean force) {
    this.force = force;
  }

  public static Builder builder() {
    return new Builder();
  }

  public boolean isForce() {
    return force;
  }

  public static class Builder {

    private boolean force;

    public Builder force(boolean force) {
      this.force = force;
      return this;
    }

    public UpgradeOptions build() {
      return new UpgradeOptions(force);
    }
  }
}
