/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.domain.enums;

import static java.nio.file.Paths.get;
import static java.util.EnumSet.allOf;
import static java.util.stream.Collectors.toList;

import java.nio.file.Path;
import java.util.List;

/**
 * Defines all the paths of files that should be excluded of the back up and upgrade process.
 */
public enum PathToBeExcluded {

  CONF_LICENSE(get("conf", "licenseKeyStore")), CONF_MULE(get("conf", "mule.pub"));

  private Path path;

  /**
   * Gets the list of all {@link Path} defined by all the values of this enumeration.
   *
   * @return list of all paths defined by each of the value of this enumeration.
   */
  public static List<Path> getAllPaths() {
    return allOf(PathToBeExcluded.class).stream().map(PathToBeExcluded::getPath).collect(toList());
  }

  PathToBeExcluded(Path path) {
    this.path = path;
  }

  public Path getPath() {
    return path;
  }
}
