/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.domain.enums;

import static java.nio.file.Paths.get;
import static java.util.EnumSet.allOf;
import static java.util.stream.Collectors.toList;

import java.nio.file.Path;
import java.util.List;

/**
 * Defines all the paths of files that should be additionally backed up because are somehow impacted by the upgrade process.
 */
public enum PathsToBeAdditionallyBackedUp {

  LIB(get("lib")), BIN(get("bin")), SERVER_PLUGIN(get("server-plugins")), SERVICES(get("services")), TOOLS(
      get("tools")), CONF(get("conf"));

  private Path path;

  /**
   * Gets the list of all {@link Path} defined by all the values of this enumeration.
   *
   * @return list of all paths defined by each of the value of this enumeration.
   */
  public static List<Path> getAllPaths() {
    return allOf(PathsToBeAdditionallyBackedUp.class).stream().map(PathsToBeAdditionallyBackedUp::getPath).collect(toList());
  }

  PathsToBeAdditionallyBackedUp(Path path) {
    this.path = path;
  }

  public Path getPath() {
    return path;
  }
}
