/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.runtime.upgrade.tool.service.api;

import java.io.IOException;
import java.nio.file.Path;


/**
 * This service manages file descriptor's functionalities.
 */
public interface DescriptorService {

  /**
   * This method creates file descriptor of the current mule version and then compares with the newest file descriptor version.
   *
   * @param oldMulePath Path of the current mule distro.
   * @param newMulePath Path of the newest mule distro.
   * @throws IOException I/O Exception.
   */
  void compareMuleDistros(Path oldMulePath, Path newMulePath) throws IOException;
}
