/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.service.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.List;

/**
 * A services for Mule distribution patches handling.
 */
public interface DistroPatchService {

  /**
   * Retrieves all the file paths of the applied patches of a given Mule Runtime Distribution if any.
   *
   * @param muleDistribution location of the Mule distribution where backup could reside.
   * @throws FileNotFoundException if patches dir is not found within the given mule distro location.
   */
  List<File> getAppliedPatches(Path muleDistribution) throws FileNotFoundException;
}
