/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.command;

import com.mulesoft.runtime.upgrade.tool.domain.RollbackOptions;
import com.mulesoft.runtime.upgrade.tool.service.api.RollbackService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@Component
@CommandLine.Command(name="rollback", description={"Rollbacks a Mule Runtime upgrade from a backup"})
public class RollbackCommand
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RollbackCommand.class);
    @CommandLine.Option(names={"-o", "--old-mule-distro"}, description={"File path of Mule Runtime distribution upgraded with the tool"}, required=true)
    Path oldMuleDistro;
    @CommandLine.Option(names={"-f", "--force"}, description={"Performs backup restoration without requesting user confirmation"})
    boolean force;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display this help message"})
    boolean usageHelpRequested;
    @Autowired
    private RollbackService rollBackService;

    @Override
    public Integer call() throws IOException {
        LOGGER.info("Initiating rollback process... ");
        LOGGER.debug("Mule distribution location: [{}]", (Object)this.oldMuleDistro);
        RollbackOptions rollbackOptions = RollbackOptions.builder().force(this.force).build();
        this.rollBackService.rollback(this.oldMuleDistro, rollbackOptions);
        return 0;
    }

    public void setOldMuleDistro(Path oldMuleDistro) {
        this.oldMuleDistro = oldMuleDistro;
    }
}

