/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.domain;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemVer
implements Comparable<SemVer> {
    private static final String SEM_VER_PARSE_REGEX = "(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?(?:\\-([\\w][\\w\\.\\-_]*))?)?";
    private int major;
    private int minor;
    private int patch;
    private String suffix;

    public static SemVer valueOf(String semVer) {
        Pattern compile = Pattern.compile(SEM_VER_PARSE_REGEX);
        Matcher matcher = compile.matcher(semVer);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("%s could not be parsed as semVer value", semVer));
        }
        String suffix = matcher.group(4) != null ? matcher.group(4) : "";
        return new SemVer(Integer.valueOf(matcher.group(1)).intValue(), Integer.valueOf(matcher.group(2)).intValue(), Integer.valueOf(matcher.group(3)).intValue(), suffix);
    }

    private SemVer(int major, int minor, int patch, String metadata) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.suffix = metadata;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemVer semVer = (SemVer)o;
        if (this.getMajor() != semVer.getMajor()) {
            return false;
        }
        if (this.getMinor() != semVer.getMinor()) {
            return false;
        }
        if (this.getPatch() != semVer.getPatch()) {
            return false;
        }
        return this.getSuffix().equals(semVer.getSuffix());
    }

    public int hashCode() {
        int result = this.getMajor();
        result = 31 * result + this.getMinor();
        result = 31 * result + this.getPatch();
        result = 31 * result + this.getSuffix().hashCode();
        return result;
    }

    public String toString() {
        if (this.suffix.isEmpty()) {
            return String.format("%s.%s.%s", this.major, this.minor, this.patch);
        }
        return String.format("%s.%s.%s-%s", this.major, this.minor, this.patch, this.suffix);
    }

    @Override
    public int compareTo(SemVer o) {
        return Comparator.comparingInt(SemVer::getMajor).thenComparingInt(SemVer::getMinor).thenComparingInt(SemVer::getPatch).thenComparing(SemVer::getSuffix).compare(this, o);
    }
}

