/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.domain.BackupDescriptor;
import com.mulesoft.runtime.upgrade.tool.domain.MuleDistribution;
import com.mulesoft.runtime.upgrade.tool.service.api.AppService;
import com.mulesoft.runtime.upgrade.tool.service.api.BackupService;
import com.mulesoft.runtime.upgrade.tool.service.api.FileSystemService;
import com.mulesoft.runtime.upgrade.tool.service.api.PreconditionsValidatorService;
import com.mulesoft.runtime.upgrade.tool.service.api.UpgradeConfigService;
import com.mulesoft.runtime.upgrade.tool.service.api.YamlService;
import com.mulesoft.runtime.upgrade.tool.utils.PrettyPrintingFormatter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultBackupService
implements BackupService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBackupService.class);
    @Autowired
    private AppService appService;
    @Autowired
    private UpgradeConfigService upgradeConfigService;
    @Autowired
    private YamlService yamlService;
    @Autowired
    private FileSystemService fileSystemService;
    @Autowired
    private PreconditionsValidatorService preconditionsValidatorService;
    private Clock clock;

    public void create(MuleDistribution muleDistribution, List<Path> relativePathOfFilesToBeBackedUp) throws IOException {
        LOGGER.debug("Creating backup for distro: {}", (Object)muleDistribution);
        Path muleLocation = muleDistribution.getLocation();
        try {
            this.checkPossibleBackupOverwriting(muleLocation);
            this.purgeBackupDir(muleLocation);
            Path backupDestDir = muleLocation.resolve(this.upgradeConfigService.getBackupFolderName());
            this.fileSystemService.copyFiles(muleLocation, backupDestDir, relativePathOfFilesToBeBackedUp);
            this.generateDescriptor(muleDistribution);
        }
        catch (IOException e) {
            this.deleteBackupFolder(muleLocation);
            throw new IOException("Backup creation failed.", e);
        }
    }

    private void checkPossibleBackupOverwriting(Path muleLocation) throws IOException {
        List messages = this.preconditionsValidatorService.checkBackupExistence(muleLocation);
        if (messages.isEmpty()) {
            this.printBackUpDescriptor(this.readBackupDescriptor(muleLocation));
            if (!this.preconditionsValidatorService.getConsentForOverwritingBackup(false)) {
                LOGGER.error("Consent is needed for overriding current backup.");
                throw new IllegalStateException("Consent is needed for overriding current backup.");
            }
        }
    }

    public Optional<BackupDescriptor> readBackupDescriptor(Path muleDistributionHome) throws IOException {
        LOGGER.debug("Reading backup descriptor...");
        File yamlDescriptor = muleDistributionHome.resolve(this.getBackupDescriptorPath()).toFile();
        if (!yamlDescriptor.exists()) {
            LOGGER.debug("No backup descriptor found");
            return Optional.empty();
        }
        return Optional.of(this.yamlService.readValue(yamlDescriptor, BackupDescriptor.class));
    }

    private void purgeBackupDir(Path muleLocation) throws IOException {
        File backupDestDir = muleLocation.resolve(this.upgradeConfigService.getBackupFolderName()).toFile();
        if (backupDestDir.exists()) {
            LOGGER.debug("Deleting backup folder at: {}", (Object)backupDestDir);
            FileUtils.forceDelete((File)backupDestDir);
        }
        this.createBackupDirectory(backupDestDir);
    }

    private void createBackupDirectory(File backupDestDir) throws IOException {
        backupDestDir.mkdirs();
        if (this.fileSystemService.isWindowsOs()) {
            Files.setAttribute(backupDestDir.toPath(), "dos:hidden", true, new LinkOption[0]);
        }
    }

    public void printBackUpDescriptor(Optional<BackupDescriptor> backupDescriptor) {
        if (backupDescriptor.isPresent()) {
            String backupDescriptorPrettyFormatted = String.format("%n%s", PrettyPrintingFormatter.formatBackupDescriptor((BackupDescriptor)backupDescriptor.get()));
            LOGGER.info(backupDescriptorPrettyFormatted);
        }
    }

    private void generateDescriptor(MuleDistribution muleDistribution) throws IOException {
        String muleVersion = muleDistribution.getVersion().toString();
        Path muleLocation = muleDistribution.getLocation();
        BackupDescriptor backupDescriptor = BackupDescriptor.builder().backupGenerationTimestamp(Instant.now(this.getClock())).upgradeToolVersion(this.appService.getVersion()).muleRuntimeDistributionVersion(muleVersion).build();
        File yamlDescriptor = muleLocation.resolve(this.getBackupDescriptorPath()).toFile();
        this.yamlService.writeValueToFile(yamlDescriptor, (Object)backupDescriptor);
    }

    private Path getBackupDescriptorPath() {
        return Paths.get(this.upgradeConfigService.getBackupFolderName(), this.upgradeConfigService.getBackupDescriptorFileName());
    }

    private void deleteBackupFolder(Path muleHome) throws IOException {
        File backupDir = muleHome.resolve(this.upgradeConfigService.getBackupFolderName()).toFile();
        if (backupDir.exists()) {
            FileUtils.forceDelete((File)backupDir);
        }
    }

    public Clock getClock() {
        if (this.clock == null) {
            this.clock = Clock.systemDefaultZone();
        }
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }
}

