/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.mulesoft.runtime.upgrade.tool.domain.AssemblyEntry;
import com.mulesoft.runtime.upgrade.tool.domain.enums.PathToBeExcluded;
import com.mulesoft.runtime.upgrade.tool.domain.enums.PathsToBeReplaced;
import com.mulesoft.runtime.upgrade.tool.service.DefaultBackupService;
import com.mulesoft.runtime.upgrade.tool.service.api.DescriptorService;
import com.mulesoft.runtime.upgrade.tool.service.api.YamlService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultDescriptorService
implements DescriptorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBackupService.class);
    @Autowired
    private YamlService yamlService;
    private static final String FILE_DESCRIPTOR_CURRENT_DISTRO = "file-descriptor-current-distro.yaml";
    private static final String FILE_DESCRIPTOR_NEW_DISTRO = "file-descriptor-new-distro.yaml";
    private static final String MULE_UPGRADE_TOOL = "tools/mule-runtime-upgrade-tool-1.0.0-SNAPSHOT.jar";
    private List<AssemblyEntry> entries = new ArrayList();

    public void compareMuleDistros(Path oldMulePath, Path newMulePath) throws IOException {
        LOGGER.debug("Creating file descriptor of old distro...");
        this.createFileDescriptor(oldMulePath);
        File file = new File(FILE_DESCRIPTOR_CURRENT_DISTRO);
        file.deleteOnExit();
        LOGGER.debug("Comparing file descriptors...");
        this.compareMuleDistros(newMulePath);
    }

    private void compareMuleDistros(Path newMulePath) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        CollectionType listType = mapper.getTypeFactory().constructCollectionType(LinkedList.class, AssemblyEntry.class);
        List oldDistroFileDescriptor = (List)mapper.readValue(new File(FILE_DESCRIPTOR_CURRENT_DISTRO), (JavaType)listType);
        List newDistroFileDescriptor = (List)mapper.readValue(new File(newMulePath + "/" + FILE_DESCRIPTOR_NEW_DISTRO), (JavaType)listType);
        List excludedPaths = PathToBeExcluded.getAllPaths().stream().map(x -> x.toFile().getName()).collect(Collectors.toList());
        oldDistroFileDescriptor.forEach(x -> {
            if (!(newDistroFileDescriptor.contains(x) || x.getName().equals(MULE_UPGRADE_TOOL) || FilenameUtils.getExtension((String)x.getName()).equals("lic") || excludedPaths.contains(x.getName()))) {
                LOGGER.warn(x.getName() + " will be deleted.");
            }
        });
    }

    private void createFileDescriptor(Path mulePath) throws IOException {
        List allPaths = PathsToBeReplaced.getAllPaths();
        for (Path path : allPaths) {
            try {
                this.recursiveFileTreeWrapper(mulePath.resolve(path));
            }
            catch (IOException e) {
                throw new IOException(path + " was not found.", e);
            }
        }
        try {
            this.yamlService.writeValueToFile(new File(FILE_DESCRIPTOR_CURRENT_DISTRO), (Object)this.entries);
        }
        catch (IOException e) {
            throw new IOException("Error generating the distribution assembly content descriptor", e);
        }
    }

    private void extractEntryInfo(File file, String parentDirectory) throws IOException {
        try {
            byte[] contents = FileUtils.readFileToByteArray((File)file);
            String sha256 = DigestUtils.sha256Hex((byte[])contents);
            this.entries.add(new AssemblyEntry(parentDirectory, (long)contents.length, sha256));
        }
        catch (IOException e) {
            throw new IOException("Error generating the Mule distribution assembly descriptor", e);
        }
    }

    private void recursiveFileTreeWrapper(Path directory) throws IOException {
        this.recursiveFileTree(directory, directory.toFile().getName());
    }

    private void recursiveFileTree(Path path, String parent) throws IOException {
        if (path == null) {
            return;
        }
        File file = path.toFile();
        if (file.isFile()) {
            this.extractEntryInfo(file, parent);
            return;
        }
        if (file.isDirectory()) {
            for (File elem : file.listFiles()) {
                this.recursiveFileTree(elem.toPath(), parent + "/" + elem.getName());
            }
        }
    }
}

