/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.service.api.DistroPatchService;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultDistroPatchService
implements DistroPatchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDistroPatchService.class);
    private static final String PATCHES_NAME_REGEX = "^.*\\.jar$";
    protected static final Path PATCHES_DIR = Paths.get("lib", "patches");

    public List<File> getAppliedPatches(Path muleDistribution) throws FileNotFoundException {
        Path patchesDir = muleDistribution.resolve(PATCHES_DIR);
        List patches = this.findPatches(patchesDir.toFile());
        if (!patches.isEmpty()) {
            LOGGER.debug("The following patches were found at {}: {}", (Object)patchesDir, (Object)patches);
        } else {
            LOGGER.debug("No applied patches found at {}", (Object)patchesDir);
        }
        return patches;
    }

    private List<File> findPatches(File patchesDir) throws FileNotFoundException {
        if (!patchesDir.isDirectory()) {
            throw new FileNotFoundException(String.format("Expected patches dir does not exists at: %s", patchesDir));
        }
        RegexFileFilter fileFilter = new RegexFileFilter(PATCHES_NAME_REGEX);
        return Arrays.asList(patchesDir.listFiles((FileFilter)fileFilter));
    }
}

