/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.domain.BackupDescriptor;
import com.mulesoft.runtime.upgrade.tool.domain.MuleDistribution;
import com.mulesoft.runtime.upgrade.tool.domain.SemVer;
import com.mulesoft.runtime.upgrade.tool.domain.enums.RollbackPreconditions;
import com.mulesoft.runtime.upgrade.tool.domain.enums.UpgradePreconditions;
import com.mulesoft.runtime.upgrade.tool.service.api.BackupService;
import com.mulesoft.runtime.upgrade.tool.service.api.DistroPatchService;
import com.mulesoft.runtime.upgrade.tool.service.api.FileSystemService;
import com.mulesoft.runtime.upgrade.tool.service.api.MuleStatusService;
import com.mulesoft.runtime.upgrade.tool.service.api.PreconditionsValidator;
import com.mulesoft.runtime.upgrade.tool.service.api.UserInteractionService;
import com.mulesoft.runtime.upgrade.tool.service.utils.PathDefinitionUtils;
import com.mulesoft.runtime.upgrade.tool.utils.PrettyPrintingFormatter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultPreconditionsValidator
implements PreconditionsValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPreconditionsValidator.class);
    @Autowired
    private BackupService backupService;
    @Autowired
    private FileSystemService fileSystemService;
    @Autowired
    private MuleStatusService statusService;
    @Autowired
    private UserInteractionService userInteractionService;
    @Autowired
    private DistroPatchService patchService;

    public void checkUpgradeReadiness(MuleDistribution oldMule, MuleDistribution newMule, boolean force) throws IOException {
        LOGGER.debug("Validating if all preconditions to proceed with the upgrade are met...");
        EnumMap<UpgradePreconditions, Boolean> preconditionsMet = new EnumMap<UpgradePreconditions, Boolean>(UpgradePreconditions.class);
        preconditionsMet.put(UpgradePreconditions.NEW_MULE_IS_NEWER, this.checkNewMuleIsNewer(oldMule.getVersion(), newMule.getVersion()));
        preconditionsMet.put(UpgradePreconditions.OLD_MULE_WRITING_PERMISSIONS, this.checkWritingPermissions(oldMule.getLocation()));
        preconditionsMet.put(UpgradePreconditions.NEW_MULE_READING_PERMISSIONS, this.checkReadingPermissions(newMule.getLocation()));
        preconditionsMet.put(UpgradePreconditions.FILE_SYSTEM_SPACE, this.checkEnoughUsableSpace(oldMule.getLocation(), newMule.getLocation()));
        preconditionsMet.put(UpgradePreconditions.OLD_MULE_NOT_RUNNING, this.isMuleStopped(oldMule.getLocation()));
        preconditionsMet.put(UpgradePreconditions.CONSENT_TO_OVERWRITE_BACKUP, this.getConsentForOverwritingBackup(oldMule.getLocation(), force));
        preconditionsMet.put(UpgradePreconditions.CONSENT_TO_REMOVE_APPLIED_PATCHES, this.getConsentForRemovingAppliedPatches(oldMule.getLocation(), force));
        if (preconditionsMet.values().contains(false)) {
            throw new IllegalStateException("Not all preconditions were met for performing the upgrade. Review the log for details.");
        }
    }

    private boolean checkNewMuleIsNewer(SemVer oldDistro, SemVer newDistro) {
        if (oldDistro.compareTo(newDistro) >= 0) {
            LOGGER.error("Version of new Mule distribution {} should be newer than old Mule distribution: {}", (Object)newDistro, (Object)oldDistro);
            return false;
        }
        return true;
    }

    public void checkRollbackReadiness(Path muleDistroLocation) throws IOException {
        LOGGER.debug("Validating if all preconditions to proceed with the rollback are met...");
        EnumMap<RollbackPreconditions, Boolean> preconditionsMet = new EnumMap<RollbackPreconditions, Boolean>(RollbackPreconditions.class);
        preconditionsMet.put(RollbackPreconditions.BACKUP, this.checkBackupExistence(muleDistroLocation));
        preconditionsMet.put(RollbackPreconditions.WRITING_PERMISSIONS, this.checkWritingPermissions(muleDistroLocation));
        preconditionsMet.put(RollbackPreconditions.MULE_NOT_RUNNING, this.isMuleStopped(muleDistroLocation));
        if (preconditionsMet.values().contains(false)) {
            throw new IllegalStateException("Not all preconditions were met for performing the rollback. Review the log for details.");
        }
    }

    private boolean getConsentForOverwritingBackup(Path distroLocation, boolean force) throws IOException {
        Optional backupDescriptor = this.backupService.readBackupDescriptor(distroLocation);
        if (!backupDescriptor.isPresent()) {
            LOGGER.debug("No existent backup found for Mule Runtime distribution: [{}]", (Object)distroLocation);
            return true;
        }
        LOGGER.info("Backup found for Mule Runtime distribution: [{}]", (Object)distroLocation);
        String backupDescriptorPrettyFormatted = String.format("%n%s", PrettyPrintingFormatter.formatBackupDescriptor((BackupDescriptor)((BackupDescriptor)backupDescriptor.get())));
        LOGGER.info(backupDescriptorPrettyFormatted);
        if (force) {
            LOGGER.debug("Consent to overwrite backup is set through force parameter.");
            return true;
        }
        return this.userInteractionService.confirmAction("overwrite backup", "Could backup be overwritten?", false);
    }

    private boolean getConsentForRemovingAppliedPatches(Path distroLocation, boolean force) throws IOException {
        List appliedPatches = this.patchService.getAppliedPatches(distroLocation);
        if (appliedPatches.isEmpty()) {
            LOGGER.debug("No applied patches found for Mule Runtime distribution: [{}]", (Object)distroLocation);
            return true;
        }
        LOGGER.info("Applied patches found for Mule Runtime distribution: [{}]", (Object)distroLocation);
        String appliedPatchesListPrettyFormatted = String.format("%n%s", PrettyPrintingFormatter.formatAppliedPatches((List)appliedPatches));
        LOGGER.info(appliedPatchesListPrettyFormatted);
        if (force) {
            LOGGER.debug("Consent to remove applied patches is set through force parameter.");
            return true;
        }
        return this.userInteractionService.confirmAction("remove patches", "Could patched be removed?", false);
    }

    private boolean checkBackupExistence(Path muleDistroLocation) throws IOException {
        Optional backupDescriptor = this.backupService.readBackupDescriptor(muleDistroLocation);
        if (!backupDescriptor.isPresent()) {
            LOGGER.error("Backup does not exist for Mule Runtime distribution: [{}]", (Object)muleDistroLocation);
        } else {
            LOGGER.debug("Backup found for Mule Runtime distribution: [{}]", (Object)muleDistroLocation);
            String backUpDescriptorPrettyFormatted = String.format("%n%s", PrettyPrintingFormatter.formatBackupDescriptor((BackupDescriptor)((BackupDescriptor)backupDescriptor.get())));
            LOGGER.debug(backUpDescriptorPrettyFormatted);
        }
        return backupDescriptor.isPresent();
    }

    private boolean checkWritingPermissions(Path muleDistroLocation) {
        try {
            this.fileSystemService.checkWritingAccess(muleDistroLocation, PathDefinitionUtils.getAllDefinedPaths());
            LOGGER.debug("Writing permissions found for all expected paths within the Mule distribution [{}]", (Object)muleDistroLocation);
            return true;
        }
        catch (IOException e) {
            LOGGER.error(String.format("Error validating required writing permissions under Mule distribution [%s]", muleDistroLocation), (Throwable)e);
            return false;
        }
    }

    private boolean checkEnoughUsableSpace(Path oldMule, Path newMule) {
        try {
            this.fileSystemService.checkEnoughUsableSpace(oldMule, newMule, PathDefinitionUtils.getAllDefinedPaths());
            LOGGER.debug("There's enough disk space for performing the upgrade.");
            return true;
        }
        catch (IOException e) {
            LOGGER.error("There's not enough disk space for performing the upgrade.");
            return false;
        }
    }

    private boolean checkReadingPermissions(Path muleDistroLocation) {
        try {
            this.fileSystemService.checkReadingAccess(muleDistroLocation, PathDefinitionUtils.getAllDefinedPaths());
            LOGGER.debug("Reading permissions found for all expected paths within the Mule distribution [{}]", (Object)muleDistroLocation);
            return true;
        }
        catch (IOException e) {
            LOGGER.error(String.format("Error validating required reading permissions under Mule distribution [%s]", muleDistroLocation), (Throwable)e);
            return false;
        }
    }

    private boolean isMuleStopped(Path muleDistroLocation) throws IOException {
        try {
            this.statusService.checkStopped(muleDistroLocation);
        }
        catch (IllegalStateException e) {
            LOGGER.error("Mule Runtime should be stopped.");
            return false;
        }
        LOGGER.debug("Mule Distribution located at [{}] is stopped.", (Object)muleDistroLocation);
        return true;
    }
}

