/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.mulesoft.runtime.upgrade.tool.service.api.YamlService;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultYamlService
implements YamlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultYamlService.class);

    public void writeValueToFile(File resultFile, Object object) throws IOException {
        LOGGER.debug("Writing object to YAML file at {}", (Object)resultFile);
        this.buildYamlObjectMapper().writeValue(resultFile, object);
    }

    public <T> T readValue(File src, Class<T> valueType) throws IOException {
        LOGGER.debug("Reading value from YAML file at {}", (Object)src);
        return (T)this.buildYamlObjectMapper().readValue(src, valueType);
    }

    private ObjectMapper buildYamlObjectMapper() {
        return new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER)).setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).registerModule((Module)new JavaTimeModule());
    }
}

