/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.command;

import static picocli.CommandLine.IExecutionExceptionHandler;
import static picocli.CommandLine.ParseResult;

import org.springframework.stereotype.Component;
import picocli.CommandLine;

/**
 * This class handles any exception which happened during the execution of the tool.
 */
@Component
public class ExecutionExceptionHandler implements IExecutionExceptionHandler {

  @Override
  public int handleExecutionException(Exception ex, CommandLine cmd, ParseResult parseResult) throws Exception {
    // @todo[DEL-2805]: Given that logging is getting more traction due to auditability needs, we might need to rethink this
    // implementation because this logging is not part of the default logging mechanism

    // bold red error message
    cmd.getErr().println(cmd.getColorScheme().errorText(ex.getMessage()));

    return cmd.getExitCodeExceptionMapper() != null
        ? cmd.getExitCodeExceptionMapper().getExitCode(ex)
        : cmd.getCommandSpec().exitCodeOnExecutionException();
  }
}
