/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.command;

import static picocli.CommandLine.IVersionProvider;

import com.mulesoft.runtime.upgrade.tool.service.api.AppService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * This class gets to know the version of upgrade tool.
 */
@Component
public class UpgradeToolVersionProvider implements IVersionProvider {

  @Autowired
  private AppService appService;

  @Override
  public String[] getVersion() throws Exception {
    return new String[] {appService.getName() + " " + appService.getVersion()};
  }

}
