/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.runtime.upgrade.tool.domain;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * File Descriptor Entity.
 */
@JsonNaming(PropertyNamingStrategies.KebabCaseStrategy.class)
public class AssemblyEntry {

  private String name;
  private long sizeInBytes;
  private String sha256;

  public AssemblyEntry(String name, long sizeInBytes, String sha256) {
    this.name = name;
    this.sizeInBytes = sizeInBytes;
    this.sha256 = sha256;
  }

  public AssemblyEntry() {}

  public String getName() {
    return name;
  }

  public long getSizeInBytes() {
    return sizeInBytes;
  }

  public String getSha256() {
    return sha256;
  }

  @Override
  public String toString() {
    return "AssemblyEntry{" +
        "name='" + name + '\'' +
        ", sizeInBytes=" + sizeInBytes +
        ", sha256='" + sha256 + '\'' +
        '}';
  }

  @Override
  public boolean equals(Object o) {
    if (this == o)
      return true;
    if (!(o instanceof AssemblyEntry))
      return false;

    AssemblyEntry that = (AssemblyEntry) o;

    if (getSizeInBytes() != that.getSizeInBytes())
      return false;
    if (getName() != null ? !getName().equals(that.getName()) : that.getName() != null)
      return false;
    return getSha256() != null ? getSha256().equals(that.getSha256()) : that.getSha256() == null;
  }

  @Override
  public int hashCode() {
    int result = getName() != null ? getName().hashCode() : 0;
    result = 31 * result + (int) (getSizeInBytes() ^ (getSizeInBytes() >>> 32));
    result = 31 * result + (getSha256() != null ? getSha256().hashCode() : 0);
    return result;
  }
}
