/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.service.api;

import com.mulesoft.runtime.upgrade.tool.domain.MuleDistribution;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;

/**
 * A service for {@link MuleDistribution} operations.
 */
public interface MuleDistroService {

  /**
   * Initializes a {@link MuleDistribution} object after validating that the given file path corresponds to a Mule Runtime
   * distribution.
   *
   * @param muleHome a path pointing to a Mule Runtime distribution.
   * @return a {@link MuleDistribution} instance.
   * @throws NotDirectoryException if given muleHome path is not a directory.
   * @throws FileNotFoundException if mule-core jar used for determining the Mule distro version is not found.
   */
  MuleDistribution initMuleDistro(Path muleHome) throws IOException;

  /**
   * Introspects the given directory to determine if it looks like a Mule Runtime distribution.
   *
   * @param muleDistroLocation a path pointing to a potential Mule Runtime distribution.
   * @throws IOException if given muleHome path does not look like a distro.
   */
  void looksLikeADistro(Path muleDistroLocation) throws IOException;

  /**
   * Detects Mule Runtime Distribution version.
   *
   * @param muleHome Mule Runtime Distribution path.
   * @return Mule Runtime Distribution version.
   * @throws FileNotFoundException if muleHome path is not found.
   */
  String detectMuleVersion(Path muleHome) throws FileNotFoundException;

  /**
   * Checks if current mule distro is working on cluster mode.
   *
   * @param currentMuleDistroPropertiesFilePath Current mule distro path.
   * @throws IOException I/O Exception.
   * @return
   */
  boolean checkClusterModeIsActive(Path currentMuleDistroPropertiesFilePath) throws IOException;
}
