/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.service.api;

import java.io.IOException;
import java.nio.file.Path;

/**
 * A service for Mule Runtime process-related operations.
 */
public interface MuleStatusService {

  /**
   * Checks whether a Mule Runtime distribution is stopped.
   *
   * @param muleDistribution a {@code MuleDistribution} object.
   *
   * @throws IllegalStateException if Mule runtime is running.
   * @throws IOException           if there's any issue while interacting with the mule binary.
   */
  void checkStopped(Path muleDistribution) throws IOException;

}
