/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.service.api;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;

/**
 * A service for status command.
 */
public interface StatusService {

  /**
   * Runs different processes for showing to the user some relevant information about Mule distribution and possible actions for
   * executing with the tool.
   * 
   * @param oldMule Old Mule distro path.
   * @throws FileNotFoundException File not found Exception.
   */
  void statusCommandExecute(Path oldMule) throws IOException;
}
