/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.service.api;

import java.io.IOException;

/**
 * Service for interacting with the end user.
 */
public interface UserInteractionService {

  /**
   * Requests yes/no confirmation for an action given its description. Interaction takes place by Java standard input and output
   * streams. Take into account this will imply blocking calls.
   *
   * @param desc                a short description of the action to confirm for logging purposes.
   * @param messageToUser       the message that should be shown to the user for requesting confirmation.
   * @param defaultConfirmation false, if default confirmation answer should be No, true otherwise.
   *
   * @return true if the user accepts, false otherwise.
   * @throws IOException on any I/O related exception like no Console associated to the JVM.
   */
  boolean confirmAction(String desc, String messageToUser, boolean defaultConfirmation) throws IOException;
}
