/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.domain.RollbackOptions;
import com.mulesoft.runtime.upgrade.tool.domain.enums.PathToBeExcluded;
import com.mulesoft.runtime.upgrade.tool.service.api.DescriptorService;
import com.mulesoft.runtime.upgrade.tool.service.api.FileSystemService;
import com.mulesoft.runtime.upgrade.tool.service.api.MuleDistroService;
import com.mulesoft.runtime.upgrade.tool.service.api.RollbackService;
import com.mulesoft.runtime.upgrade.tool.service.api.StatusPreconditionsValidatorService;
import com.mulesoft.runtime.upgrade.tool.service.api.UpgradeConfigService;
import com.mulesoft.runtime.upgrade.tool.service.api.UserInteractionService;
import com.mulesoft.runtime.upgrade.tool.service.utils.PathDefinitionUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultRollbackService
implements RollbackService {
    public static final String USER_REJECTED_TO_PROCEED_WITH_THE_ROLLBACK_PROCESS_MESSAGE = "User has rejected to proceed with the rollback process";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRollbackService.class);
    @Autowired
    private MuleDistroService muleDistroService;
    @Autowired
    private StatusPreconditionsValidatorService statusPreconditionsValidatorService;
    @Autowired
    private UpgradeConfigService upgradeConfigService;
    @Autowired
    private FileSystemService fileSystemService;
    @Autowired
    private UserInteractionService userInteractionService;
    @Autowired
    private DescriptorService descriptorService;

    public void rollback(Path muleDistroLocation, RollbackOptions rollbackOptions) throws IOException {
        LOGGER.info("Preparing rollback process...");
        this.muleDistroService.looksLikeADistro(muleDistroLocation);
        List possibleErrors = this.statusPreconditionsValidatorService.checkRollbackPreconditions(muleDistroLocation);
        if (!possibleErrors.isEmpty()) {
            throw new IllegalStateException("Not all preconditions were met for performing the rollback. Review the log for details.");
        }
        this.muleDistroService.checkClusterModeIsActive(muleDistroLocation);
        this.descriptorService.compareMuleDistros(muleDistroLocation);
        this.requestUsersConfirmation(rollbackOptions.isForce());
        try {
            LOGGER.info("Rolling back the Mule Runtime distribution.");
            this.copyBackFiles(muleDistroLocation);
            LOGGER.info("Rollback process finished successfully.");
        }
        catch (IOException e) {
            throw new IOException("Failed to copy back files from the backup. Consider re-trying the operation after having solved the underlying failure condition, if any", e);
        }
    }

    private void requestUsersConfirmation(boolean force) throws IOException {
        if (!force && !this.userInteractionService.confirmAction("rollback upgrade", "Do you want to proceed with the rollback?", false)) {
            throw new IllegalStateException(USER_REJECTED_TO_PROCEED_WITH_THE_ROLLBACK_PROCESS_MESSAGE);
        }
    }

    protected void copyBackFiles(Path distroLocation) throws IOException {
        Path backupFolder = distroLocation.resolve(this.upgradeConfigService.getBackupFolderName());
        LOGGER.debug("Copying backed up files from [{}] to [{}]...", (Object)backupFolder, (Object)distroLocation);
        this.fileSystemService.copyFiles(backupFolder, distroLocation, PathDefinitionUtils.getAllDefinedPaths(), PathToBeExcluded.getAllPaths());
    }
}

