/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.domain.BackupDescriptor;
import com.mulesoft.runtime.upgrade.tool.domain.MuleDistribution;
import com.mulesoft.runtime.upgrade.tool.domain.SemVer;
import com.mulesoft.runtime.upgrade.tool.domain.enums.UpgradePrecondition;
import com.mulesoft.runtime.upgrade.tool.service.DefaultPreconditionsValidatorService;
import com.mulesoft.runtime.upgrade.tool.service.api.BackupService;
import com.mulesoft.runtime.upgrade.tool.service.api.DistroPatchService;
import com.mulesoft.runtime.upgrade.tool.service.api.FileSystemService;
import com.mulesoft.runtime.upgrade.tool.service.api.MuleStatusService;
import com.mulesoft.runtime.upgrade.tool.service.api.StatusPreconditionsValidatorService;
import com.mulesoft.runtime.upgrade.tool.service.api.UserInteractionService;
import com.mulesoft.runtime.upgrade.tool.service.utils.PathDefinitionUtils;
import com.mulesoft.runtime.upgrade.tool.utils.PrettyPrintingFormatter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultStatusPreconditionsValidatorService
implements StatusPreconditionsValidatorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStatusPreconditionsValidatorService.class);
    @Autowired
    private BackupService backupService;
    @Autowired
    private FileSystemService fileSystemService;
    @Autowired
    private MuleStatusService statusService;
    @Autowired
    private UserInteractionService userInteractionService;
    @Autowired
    private DistroPatchService patchService;
    @Autowired
    private DefaultPreconditionsValidatorService preconditionsValidatorService;

    public void checkUpgradePreconditions(MuleDistribution oldMule, MuleDistribution newMule, boolean force) throws IOException {
        LOGGER.debug("Validating if all preconditions to proceed with the upgrade are met...");
        EnumMap<UpgradePrecondition, Boolean> preconditionsMet = new EnumMap<UpgradePrecondition, Boolean>(UpgradePrecondition.class);
        preconditionsMet.put(UpgradePrecondition.NEW_MULE_IS_NEWER, this.checkNewMuleIsNewer(oldMule.getVersion(), newMule.getVersion()).isEmpty());
        preconditionsMet.put(UpgradePrecondition.OLD_MULE_WRITING_PERMISSIONS, this.checkWritingPermissions(oldMule.getLocation()).isEmpty());
        preconditionsMet.put(UpgradePrecondition.NEW_MULE_READING_PERMISSIONS, this.checkReadingPermissions(newMule.getLocation()).isEmpty());
        preconditionsMet.put(UpgradePrecondition.FILE_SYSTEM_SPACE, this.checkEnoughUsableSpace(oldMule.getLocation(), newMule.getLocation()).isEmpty());
        preconditionsMet.put(UpgradePrecondition.OLD_MULE_NOT_RUNNING, this.isMuleStopped(oldMule.getLocation()).isEmpty());
        if (preconditionsMet.values().contains(false)) {
            throw new IllegalStateException("Not all preconditions were met for performing the upgrade. Review the log for details.");
        }
    }

    private boolean getConsentForRemovingAppliedPatches(Path distroLocation, boolean force) throws IOException {
        List appliedPatches = this.patchService.getAppliedPatches(distroLocation);
        if (appliedPatches.isEmpty()) {
            LOGGER.debug("No applied patches found for Mule Runtime distribution: [{}]", (Object)distroLocation);
            return true;
        }
        LOGGER.info("Applied patches found for Mule Runtime distribution: [{}]", (Object)distroLocation);
        String appliedPatchesListPrettyFormatted = String.format("%n%s", PrettyPrintingFormatter.formatAppliedPatches((List)appliedPatches));
        LOGGER.info(appliedPatchesListPrettyFormatted);
        if (force) {
            LOGGER.debug("Consent to remove applied patches is set through force parameter.");
            return true;
        }
        return this.userInteractionService.confirmAction("remove patches", "Could patched be removed?", false);
    }

    public List<String> checkUpgradeStatusOffline(MuleDistribution oldMule) throws IOException {
        LOGGER.debug("Checking pre-conditions status for upgrade process...");
        LinkedList<String> statusErrorMessages = new LinkedList<String>();
        statusErrorMessages.add("Checking upgrade process pre-conditions...");
        statusErrorMessages.addAll(this.checkWritingPermissions(oldMule.getLocation()));
        statusErrorMessages.addAll(this.isMuleStopped(oldMule.getLocation()));
        return statusErrorMessages;
    }

    public List<String> checkRollbackPreconditions(Path muleDistroLocation) throws IOException {
        LOGGER.debug("Validating if all preconditions to proceed with the rollback are met...");
        LinkedList<String> statusErrorMessages = new LinkedList<String>();
        statusErrorMessages.addAll(this.checkBackupExistence(muleDistroLocation));
        if (!this.preconditionsValidatorService.checkBackupIntegrity(muleDistroLocation)) {
            statusErrorMessages.addAll(this.preconditionsValidatorService.getBackupIntegrityErrorMessages(muleDistroLocation));
        }
        statusErrorMessages.addAll(this.checkWritingPermissions(muleDistroLocation));
        statusErrorMessages.addAll(this.isMuleStopped(muleDistroLocation));
        return statusErrorMessages;
    }

    private List<String> checkNewMuleIsNewer(SemVer oldDistro, SemVer newDistro) {
        LinkedList<String> messages = new LinkedList<String>();
        if (oldDistro.compareTo(newDistro) >= 0) {
            String message = String.format("Version of new Mule distribution {} should be newer than old Mule distribution: {}", newDistro, oldDistro);
            messages.add(message);
            LOGGER.error(message);
        }
        return messages;
    }

    public boolean getConsentForOverwritingBackup(boolean force) throws IOException {
        LOGGER.info("Asking for consent for overriding backup...");
        if (force) {
            LOGGER.debug("Consent to overwrite backup is set through force parameter.");
            return true;
        }
        return this.userInteractionService.confirmAction("overwrite backup", "Could backup be overwritten?", false);
    }

    public List<String> checkBackupExistence(Path muleDistroLocation) throws IOException {
        Optional backupDescriptor = this.backupService.readBackupDescriptor(muleDistroLocation);
        LinkedList<String> messages = new LinkedList<String>();
        if (!backupDescriptor.isPresent()) {
            String message = String.format("Backup does not exist for Mule Runtime distribution: [%s].", muleDistroLocation);
            messages.add(message);
        } else {
            LOGGER.debug("Backup found for Mule Runtime distribution: [{}]", (Object)muleDistroLocation);
            String backUpDescriptorPrettyFormatted = String.format("%n%s", PrettyPrintingFormatter.formatBackupDescriptor((BackupDescriptor)((BackupDescriptor)backupDescriptor.get())));
            LOGGER.debug(backUpDescriptorPrettyFormatted);
        }
        return messages;
    }

    private List<String> checkWritingPermissions(Path muleDistroLocation) {
        LinkedList<String> messages = new LinkedList<String>();
        try {
            this.fileSystemService.checkWritingAccess(muleDistroLocation, PathDefinitionUtils.getAllDefinedPaths());
            LOGGER.debug("Writing permissions found for all expected paths within the Mule distribution [{}]", (Object)muleDistroLocation);
        }
        catch (IOException e) {
            String message = String.format("Error validating required writing permissions under Mule distribution [%s].", muleDistroLocation);
            messages.add(message);
            LOGGER.error(message, (Throwable)e);
        }
        return messages;
    }

    private List<String> checkEnoughUsableSpace(Path oldMule, Path newMule) {
        LinkedList<String> messages = new LinkedList<String>();
        try {
            this.fileSystemService.checkEnoughUsableSpace(oldMule, newMule, PathDefinitionUtils.getAllDefinedPaths());
            LOGGER.debug("There's enough disk space for performing the upgrade.");
        }
        catch (IOException e) {
            String message = "There's not enough disk space for performing the upgrade.";
            messages.add(message);
            LOGGER.error(message);
        }
        return messages;
    }

    private List<String> checkReadingPermissions(Path muleDistroLocation) {
        LinkedList<String> messages = new LinkedList<String>();
        try {
            this.fileSystemService.checkReadingAccess(muleDistroLocation, PathDefinitionUtils.getAllDefinedPaths());
            LOGGER.debug("Reading permissions found for all expected paths within the Mule distribution [{}]", (Object)muleDistroLocation);
        }
        catch (IOException e) {
            String message = String.format("Error validating required reading permissions under Mule distribution [%s].", muleDistroLocation);
            messages.add(message);
            LOGGER.error(message, (Throwable)e);
        }
        return messages;
    }

    private List<String> isMuleStopped(Path muleDistroLocation) throws IOException {
        LinkedList<String> messages = new LinkedList<String>();
        try {
            this.statusService.checkStopped(muleDistroLocation);
        }
        catch (IllegalStateException e) {
            String message = "Mule Runtime should be stopped.";
            messages.add(message);
            LOGGER.error(message);
        }
        LOGGER.debug("Mule Distribution located at [{}] is stopped.", (Object)muleDistroLocation);
        return messages;
    }
}

