/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.command;

import com.mulesoft.runtime.upgrade.tool.service.api.StatusService;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Callable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import picocli.CommandLine.Option;
import picocli.CommandLine.Command;

/**
 * This class implements the status command received by command line.
 */
@Component
@Command(name = "status",
    description = "Shows if current Mule Distribution complies pre-conditions for being upgraded, lists possibles commands to execute, shows backup information and current Mule Distribution.")
public class StatusCommand implements Callable<Integer> {

  private static final Logger LOGGER = LoggerFactory.getLogger(StatusCommand.class);

  @Option(names = {"-o", "--old-mule-distro"}, description = "File path of Mule Runtime distribution to process current status.")
  Path oldMuleDistro;

  @Option(names = {"-h", "--help"}, usageHelp = true, description = "display this help message")
  boolean usageHelpRequested;

  @Autowired
  private StatusService statusService;

  @Override
  public Integer call() throws IOException {
    LOGGER.info("Initializing status process...");

    statusService.statusCommandExecute(oldMuleDistro);
    return 0;
  }

  public void setOldMuleDistro(Path oldMuleDistro) {
    this.oldMuleDistro = oldMuleDistro;
  }

}
