/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.service.api;

import com.mulesoft.runtime.upgrade.tool.domain.CommandOptions;

import java.io.IOException;
import java.nio.file.Path;

/**
 * Service to rollback a Mule Runtime distribution upgrade from a backup.
 */
public interface RollbackService {

  /**
   * Rolls back a Mule Runtime distribution upgrade from a backup if any exists. Copies back all the files stored in the backup to
   * their original location, leaving the Mule distribution in the same state as when the backup was created. The files are taken
   * out of the backup folder according to the upgrade configuration, in a sort of cherry-picked fashion rather than a bulk dump
   * copy of everything under the backup location.
   *
   * @param muleDistroLocation path to the Mule distribution to be rollback.
   * @param commandOptions     configuration options for the rollback process.
   *
   * @throws IOException           if an I/O error occurs.
   * @throws IllegalStateException if there's no backup for the rollback of the given Mule distro.
   */
  void rollback(Path muleDistroLocation, CommandOptions commandOptions) throws IOException;
}
