/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.service.api;

import com.mulesoft.runtime.upgrade.tool.domain.CommandOptions;

import java.io.IOException;
import java.nio.file.Path;

/**
 * Service to upgrade a Mule Runtime distribution.
 */
public interface UpgradeService {

  /**
   * Upgrades a Mule Runtime distribution based on a new given one. The upgrade process fails if any of the preconditions are not
   * met. Depending on the given options, destructive operations could be priorly confirmed interactively by the user.
   *
   * @param oldMule        path to the Mule distribution to upgrade.
   * @param newMule        path of the Mule distribution that will be used for the upgrade.
   * @param commandOptions configuration options for the upgrade.
   * @throws IOException if any I/O error occurs.
   */
  void upgrade(Path oldMule, Path newMule, CommandOptions commandOptions) throws IOException;
}
