/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.command;

import com.mulesoft.runtime.upgrade.tool.domain.CommandOptions;
import com.mulesoft.runtime.upgrade.tool.service.api.UpgradeService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@Component
@CommandLine.Command(name="upgrade", description={"Upgrades a Mule Runtime to a newer version"})
public class UpgradeCommand
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeCommand.class);
    @CommandLine.Option(names={"-o", "--old-mule-distro"}, description={"File path of Mule Runtime distribution to upgrade"}, required=true)
    Path oldMuleDistro;
    @CommandLine.Option(names={"-n", "--new-mule-distro"}, description={"File path of the newer Mule Runtime distribution used for the upgrade"}, required=true)
    Path newMuleDistro;
    @CommandLine.Option(names={"-d", "--dry-run"}, description={"Simulate upgrade process without performing any permanent changes to the current Mule Runtime Distribution."})
    boolean dryRun;
    @CommandLine.Option(names={"-f", "--force"}, description={"Perform all the destructive operations like overwriting the backup or removing the applied patches without user confirmation"})
    boolean force;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display this help message"})
    boolean usageHelpRequested;
    @Autowired
    private UpgradeService upgradeService;

    @Override
    public Integer call() throws IOException {
        LOGGER.info("Initiating upgrade process... ");
        LOGGER.debug("Old Mule distribution location: [{}]. New Mule distribution location: [{}]", (Object)this.oldMuleDistro, (Object)this.newMuleDistro);
        CommandOptions commandOptions = CommandOptions.builder().force(this.force).dryRun(this.dryRun).build();
        this.upgradeService.upgrade(this.oldMuleDistro, this.newMuleDistro, commandOptions);
        return 0;
    }

    public void setOldMuleDistro(Path oldMuleDistro) {
        this.oldMuleDistro = oldMuleDistro;
    }

    public void setNewMuleDistro(Path newMuleDistro) {
        this.newMuleDistro = newMuleDistro;
    }
}

