/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.mulesoft.runtime.upgrade.tool.domain.AssemblyEntry;
import com.mulesoft.runtime.upgrade.tool.domain.enums.PathToBeExcluded;
import com.mulesoft.runtime.upgrade.tool.domain.enums.PathToBeReplaced;
import com.mulesoft.runtime.upgrade.tool.service.api.DescriptorService;
import com.mulesoft.runtime.upgrade.tool.service.api.MuleDistroService;
import com.mulesoft.runtime.upgrade.tool.service.api.YamlService;
import com.mulesoft.runtime.upgrade.tool.utils.ClassLoaderService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultDescriptorService
implements DescriptorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDescriptorService.class);
    @Autowired
    private YamlService yamlService;
    @Autowired
    private MuleDistroService muleDistroService;
    @Autowired
    private ClassLoaderService classLoaderService;
    private static final String FILE_DESCRIPTOR_DIRECTORY = "descriptors/";
    private static final String FILE_DESCRIPTOR_GENERATED = "current-file-descriptor.yaml";
    private static final String FILE_DESCRIPTOR_PATH = "lib/mule/mule-assembly-content-descriptor-";
    private static final String FILE_DESCRIPTOR_DISTRO_FILE_NAME = "assembly-descriptor.yaml";
    private static final String ORIGINAL_FILE_DESCRIPTOR_INSIDE_CURRENT_DISTRO = "file-descriptor-inside-current-distro.yaml";
    public static final String LIC_FILE_EXTENSION_TO_REMOVE = "lic";
    private static final String MULE_UPGRADE_TOOL_PATTERN_STRING = "(.+/)?mule-runtime-upgrade-tool-((?:\\d+\\.){2}\\d+(?:-\\w+)?)\\.jar$";
    private static final String FILE_NOT_FOUND_EXCEPTION_MESSAGE = "Upgrade Tool doesn't have file descriptor of this version.";
    private static final Pattern MULE_UPGRADE_TOOL_PATTERN = Pattern.compile("(.+/)?mule-runtime-upgrade-tool-((?:\\d+\\.){2}\\d+(?:-\\w+)?)\\.jar$");
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final CollectionType LIST_TYPE = MAPPER.getTypeFactory().constructCollectionType(LinkedList.class, AssemblyEntry.class);
    private List<AssemblyEntry> entries = new ArrayList();

    public void compareMuleDistros(Path oldMulePath) throws IOException {
        LOGGER.debug("Creating file descriptor of old distro...");
        this.writeDescriptorInMuleDistro(oldMulePath);
        File file = new File(FILE_DESCRIPTOR_GENERATED);
        file.deleteOnExit();
        LOGGER.debug("Comparing file descriptors...");
        this.compare(oldMulePath);
    }

    public void compare(Path oldMulePath) throws IOException {
        List originalFileDescriptor;
        String oldMuleVersion = this.muleDistroService.detectMuleVersion(oldMulePath);
        try {
            originalFileDescriptor = this.getAssemblyEntryListOfFileDescriptorFromUpgradeTool(oldMuleVersion);
        }
        catch (IOException ex) {
            try {
                originalFileDescriptor = this.getAssemblyEntryListOfFileDescriptorFromCurrentDistribution(oldMuleVersion, oldMulePath);
            }
            catch (IOException exception) {
                return;
            }
        }
        List excludedPaths = PathToBeExcluded.getAllPaths().stream().map(x -> x.toFile().getName()).collect(Collectors.toList());
        List originalFileDescriptorWithOutParentDirectory = originalFileDescriptor.stream().map(assemblyEntry -> {
            ArrayList<String> pathsElements = new ArrayList<String>(Arrays.asList(assemblyEntry.getName().split(File.separator)));
            pathsElements.remove(0);
            String newAssemblyEntryName = String.join((CharSequence)"/", pathsElements);
            return new AssemblyEntry(newAssemblyEntryName, assemblyEntry.getSizeInBytes(), assemblyEntry.getSha256());
        }).collect(Collectors.toList());
        List currentDistroFileDescriptor = this.getAssemblyEntryListOfFileDescriptorFromGeneratedFileDescriptor(oldMulePath);
        this.compareFileDescriptors(currentDistroFileDescriptor, originalFileDescriptorWithOutParentDirectory, excludedPaths);
    }

    List<AssemblyEntry> getAssemblyEntryListOfFileDescriptorFromUpgradeTool(String currentVersion) throws IOException {
        URL url = this.classLoaderService.getURLByPath(FILE_DESCRIPTOR_DIRECTORY + currentVersion + ".yaml");
        if (url != null) {
            return (List)MAPPER.readValue(new File(url.getFile()), (JavaType)LIST_TYPE);
        }
        throw new IOException(FILE_NOT_FOUND_EXCEPTION_MESSAGE);
    }

    List<AssemblyEntry> getAssemblyEntryListOfFileDescriptorFromGeneratedFileDescriptor(Path oldMulePath) throws IOException {
        return (List)MAPPER.readValue(new File(this.getDescriptorPathInDistro(oldMulePath).toString()), (JavaType)LIST_TYPE);
    }

    List<AssemblyEntry> getAssemblyEntryListOfFileDescriptorFromCurrentDistribution(String currentVersion, Path oldMulePath) throws IOException {
        URL url = new URL("jar:file:" + oldMulePath.resolve(FILE_DESCRIPTOR_PATH + currentVersion + ".jar") + "!/" + FILE_DESCRIPTOR_DISTRO_FILE_NAME);
        JarURLConnection connection = (JarURLConnection)url.openConnection();
        File fileDescriptor = new File(ORIGINAL_FILE_DESCRIPTOR_INSIDE_CURRENT_DISTRO);
        fileDescriptor.deleteOnExit();
        try (InputStream inputStreamFile = connection.getInputStream();){
            FileUtils.copyInputStreamToFile((InputStream)inputStreamFile, (File)fileDescriptor);
            List list = (List)MAPPER.readValue(fileDescriptor, (JavaType)LIST_TYPE);
            return list;
        }
    }

    public void compareFileDescriptors(List<AssemblyEntry> currentDistroFileDescriptor, List<AssemblyEntry> originalFileDescriptor, List<String> excludedPaths) {
        currentDistroFileDescriptor.forEach(x -> {
            if (!(originalFileDescriptor.contains(x) || FilenameUtils.getExtension((String)x.getName()).equals(LIC_FILE_EXTENSION_TO_REMOVE) || excludedPaths.contains(x.getName()))) {
                LOGGER.warn(x.getName() + " will be deleted.");
            }
        });
    }

    void logEntriesNotPresentInOldDistroToBeDeleted(List<AssemblyEntry> oldDistroFileDescriptor, List<AssemblyEntry> newDistroFileDescriptor) {
        oldDistroFileDescriptor.forEach(oldDistroEntry -> {
            if (!newDistroFileDescriptor.contains(oldDistroEntry)) {
                LOGGER.warn("{} will be deleted.", (Object)oldDistroEntry.getName());
            }
        });
    }

    List<AssemblyEntry> readDescriptorFromMuleDistro(Path distroPath) throws IOException {
        Path fileDescriptorInDistro = this.getDescriptorPathInDistro(distroPath);
        return this.readDescriptor(fileDescriptorInDistro);
    }

    Path getDescriptorPathInDistro(Path distroPath) {
        return Paths.get(distroPath.toAbsolutePath().toString(), FILE_DESCRIPTOR_GENERATED);
    }

    List<AssemblyEntry> readDescriptor(Path fileDescriptor) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        CollectionType listType = mapper.getTypeFactory().constructCollectionType(LinkedList.class, AssemblyEntry.class);
        return (List)mapper.readValue(fileDescriptor.toFile(), (JavaType)listType);
    }

    List<AssemblyEntry> removeIgnoredEntries(List<AssemblyEntry> assemblyEntries) {
        List descriptorWoutIgnoredEntries = this.removeExcludedPaths(assemblyEntries);
        descriptorWoutIgnoredEntries = this.removeUpgradeToolEntry(descriptorWoutIgnoredEntries);
        descriptorWoutIgnoredEntries = this.removeEntriesWithFileExtension(descriptorWoutIgnoredEntries, LIC_FILE_EXTENSION_TO_REMOVE);
        return descriptorWoutIgnoredEntries;
    }

    List<AssemblyEntry> removeEntriesWithFileExtension(List<AssemblyEntry> descriptorEntries, String fileExtensionToRemove) {
        ArrayList<AssemblyEntry> entriesWithoutFileExtensionToRemove = new ArrayList<AssemblyEntry>(descriptorEntries);
        entriesWithoutFileExtensionToRemove.removeIf(entry -> FilenameUtils.getExtension((String)entry.getName()).equals(fileExtensionToRemove));
        return entriesWithoutFileExtensionToRemove;
    }

    List<AssemblyEntry> removeUpgradeToolEntry(List<AssemblyEntry> descriptorEntries) {
        ArrayList<AssemblyEntry> descriptorEntriesWoutUpgradeToolEntry = new ArrayList<AssemblyEntry>(descriptorEntries);
        descriptorEntriesWoutUpgradeToolEntry.removeIf(arg_0 -> this.entryNameMatchesUpgradeToolPattern(arg_0));
        return descriptorEntriesWoutUpgradeToolEntry;
    }

    private boolean entryNameMatchesUpgradeToolPattern(AssemblyEntry upgradeToolEntry) {
        return MULE_UPGRADE_TOOL_PATTERN.matcher(upgradeToolEntry.getName()).matches();
    }

    List<AssemblyEntry> removeExcludedPaths(List<AssemblyEntry> descriptorEntries) {
        return this.removeExcludedPaths(descriptorEntries, this.getListOfExcludedPaths());
    }

    List<AssemblyEntry> removeExcludedPaths(List<AssemblyEntry> descriptorEntries, List<String> excludedPaths) {
        ArrayList<AssemblyEntry> descriptorEntriesWoutExcludedPaths = new ArrayList<AssemblyEntry>(descriptorEntries);
        descriptorEntriesWoutExcludedPaths.removeIf(entry -> excludedPaths.stream().anyMatch(excludePath -> entry.getName().endsWith((String)excludePath)));
        return descriptorEntriesWoutExcludedPaths;
    }

    List<String> getListOfExcludedPaths() {
        return PathToBeExcluded.getAllPaths().stream().map(excludedPath -> excludedPath.toFile().getName()).collect(Collectors.toList());
    }

    public List<AssemblyEntry> getEntriesInPathForSelectedPaths(Path mulePath, List<Path> pathsToGetEntries) throws IOException {
        ArrayList<AssemblyEntry> currentDistroEntries = new ArrayList<AssemblyEntry>();
        for (Path path : pathsToGetEntries) {
            try {
                currentDistroEntries.addAll(this.getEntriesInPath(mulePath.resolve(path)));
            }
            catch (IOException e) {
                throw new IOException(path + " was not found.", e);
            }
        }
        return currentDistroEntries;
    }

    public List<AssemblyEntry> getEntriesInPath(Path directory) throws IOException {
        String parentDirectory = directory.toFile().getName();
        return this.recursiveFileTree(directory, parentDirectory);
    }

    public boolean checkIntegrity(List<AssemblyEntry> descriptorEntries, Path dirWithFiles) throws IOException {
        return this.checkIntegrity(descriptorEntries, dirWithFiles, this.getListOfExcludedPaths());
    }

    private boolean checkIntegrity(List<AssemblyEntry> descriptorEntries, Path dirWithFiles, List<String> pathsToExclude) throws IOException {
        List descriptorEntriesWoutExcludedPaths = this.removeExcludedPaths(descriptorEntries, pathsToExclude);
        List actualDirWithFilesEntries = this.removeExcludedPaths(this.getEntriesInPath(dirWithFiles), pathsToExclude);
        List missingAndWrongHashEntriesFromDescriptor = this.filterMissingAndWrongHashEntries(descriptorEntriesWoutExcludedPaths, actualDirWithFilesEntries);
        List missingEntriesFromDescriptor = this.filterMissingEntries(descriptorEntriesWoutExcludedPaths, actualDirWithFilesEntries);
        List wrongHashEntriesFromDescriptor = this.getWrongHashEntries(missingAndWrongHashEntriesFromDescriptor, missingEntriesFromDescriptor);
        List extraEntriesInActualDir = this.filterMissingEntries(actualDirWithFilesEntries, descriptorEntriesWoutExcludedPaths);
        this.logMissingEntries(missingEntriesFromDescriptor, dirWithFiles);
        this.logExtraEntries(extraEntriesInActualDir, dirWithFiles);
        this.logEntriesWithWrongHash(wrongHashEntriesFromDescriptor, actualDirWithFilesEntries, dirWithFiles);
        return this.areEntriesWithIntegrityErrors(missingAndWrongHashEntriesFromDescriptor, extraEntriesInActualDir);
    }

    private List<AssemblyEntry> getWrongHashEntries(List<AssemblyEntry> missingAndWrongHashEntriesFromDescriptor, List<AssemblyEntry> missingEntriesFromDescriptor) {
        ArrayList<AssemblyEntry> wrongHashEntriesFromDescriptor = new ArrayList<AssemblyEntry>(missingAndWrongHashEntriesFromDescriptor);
        wrongHashEntriesFromDescriptor.removeAll(missingEntriesFromDescriptor);
        return wrongHashEntriesFromDescriptor;
    }

    private boolean areEntriesWithIntegrityErrors(List<AssemblyEntry> missingAndWrongHashEntriesFromDescriptor, List<AssemblyEntry> extraEntriesInActualDir) {
        return missingAndWrongHashEntriesFromDescriptor.isEmpty() && extraEntriesInActualDir.isEmpty();
    }

    private void logEntriesWithWrongHash(List<AssemblyEntry> wrongHashEntries, List<AssemblyEntry> actualDirWithFilesEntries, Path dirWithFiles) {
        for (AssemblyEntry wrongHashEntry : wrongHashEntries) {
            Optional entryFoundInActualDir = this.findByEntryName(actualDirWithFilesEntries, wrongHashEntry);
            String entryFoundInActualDirHash = entryFoundInActualDir.isPresent() ? ((AssemblyEntry)entryFoundInActualDir.get()).getSha256() : "<problem getting actual hash>";
            LOGGER.warn("{} with expected hash {} doesn't match with the hash {} of the file in folder {}.", new Object[]{wrongHashEntry.getName(), wrongHashEntry.getSha256(), entryFoundInActualDirHash, dirWithFiles});
        }
    }

    private void logMissingEntries(List<AssemblyEntry> missingEntries, Path dirWithFiles) {
        missingEntries.forEach(missingEntry -> LOGGER.warn("{} file wasn't found in folder {}.", (Object)missingEntry.getName(), (Object)dirWithFiles));
    }

    private void logExtraEntries(List<AssemblyEntry> extraEntries, Path dirWithFiles) {
        extraEntries.forEach(extraEntry -> LOGGER.warn("{} extra file was found in folder {}.", (Object)extraEntry.getName(), (Object)dirWithFiles));
    }

    private List<AssemblyEntry> filterMissingAndWrongHashEntries(List<AssemblyEntry> entriesOne, List<AssemblyEntry> entriesTwo) {
        return entriesOne.stream().filter(entryOne -> !entriesTwo.contains(entryOne)).collect(Collectors.toList());
    }

    private List<AssemblyEntry> filterMissingEntries(List<AssemblyEntry> entriesOne, List<AssemblyEntry> entriesTwo) {
        return entriesOne.stream().filter(entryOne -> !this.containsEntryByName(entriesTwo, entryOne)).collect(Collectors.toList());
    }

    private boolean containsEntryByName(List<AssemblyEntry> entries, AssemblyEntry entryToFindByName) {
        return entries.stream().anyMatch(entry -> entry.getName().equals(entryToFindByName.getName()));
    }

    private Optional<AssemblyEntry> findByEntryName(List<AssemblyEntry> entries, AssemblyEntry entryToFind) {
        return entries.stream().filter(entry -> entry.getName().equals(entryToFind.getName())).findFirst();
    }

    void writeDescriptorInMuleDistro(Path muleDistroPath) throws IOException {
        List currentDistroEntries = this.getEntriesInPathForSelectedPaths(muleDistroPath, PathToBeReplaced.getAllPaths());
        this.writeFileDescriptor(currentDistroEntries, this.getDescriptorPathInDistro(muleDistroPath));
    }

    void writeFileDescriptor(List<AssemblyEntry> currentDistroEntries, Path fileDescriptorPath) throws IOException {
        try {
            this.yamlService.writeValueToFile(fileDescriptorPath.toFile(), currentDistroEntries);
        }
        catch (IOException e) {
            throw new IOException("Error generating the distribution assembly content descriptor", e);
        }
    }

    AssemblyEntry extractEntryInfo(Path entryPath, String parentFoldersFromBase) throws IOException {
        if (Files.isDirectory(entryPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Error generating the Entry for file " + entryPath.toAbsolutePath() + " because it is a directory.");
        }
        try {
            byte[] contents = FileUtils.readFileToByteArray((File)entryPath.toFile());
            String sha256 = DigestUtils.sha256Hex((byte[])contents);
            return new AssemblyEntry(parentFoldersFromBase + "/" + entryPath.getFileName().toString(), Files.size(entryPath), sha256);
        }
        catch (IOException e) {
            throw new IOException("Error generating the Entry info for file " + entryPath.toAbsolutePath(), e);
        }
    }

    private List<AssemblyEntry> recursiveFileTree(Path path, String parentFoldersFromBase) throws IOException {
        ArrayList<AssemblyEntry> assemblyEntries = new ArrayList<AssemblyEntry>();
        File file = path.toFile();
        if (file.isFile()) {
            assemblyEntries.add(this.extractEntryInfo(file.toPath(), parentFoldersFromBase));
        }
        if (file.isDirectory()) {
            String parentAux = parentFoldersFromBase + "/" + file.getName();
            if (parentFoldersFromBase.equals(file.getName())) {
                parentAux = parentFoldersFromBase;
            }
            for (File elem : file.listFiles()) {
                assemblyEntries.addAll(this.recursiveFileTree(elem.toPath(), parentAux));
            }
        }
        return assemblyEntries;
    }
}

