/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.service.api.UserInteractionService;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultUserInteractionService
implements UserInteractionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUserInteractionService.class);
    private static final String YES_NO_REGEX = "(?i)^(y(es)*|n(o)*)$";
    protected static final String YES_NO_PROMPT = "To confirm please, enter [yes, no]";
    protected static final String DEFAULT_NO_SUFFIX_PROMPT = " (default: no): ";
    protected static final String DEFAULT_YES_SUFFIX_PROMPT = " (default: yes): ";
    private InputStream in = System.in;
    private PrintStream out = System.out;

    public boolean confirmAction(String desc, String messageToUser, boolean defaultConfirmation) throws IOException {
        LOGGER.debug("Requesting confirmation for action {}", (Object)desc);
        this.checkConsoleExistence();
        Scanner scanner = new Scanner(this.in);
        this.out.println(messageToUser);
        String prompt = YES_NO_PROMPT + (defaultConfirmation ? DEFAULT_YES_SUFFIX_PROMPT : DEFAULT_NO_SUFFIX_PROMPT);
        String input = "";
        boolean validInput = false;
        while (!validInput) {
            this.out.printf(prompt, new Object[0]);
            input = scanner.nextLine().trim();
            validInput = input.matches(YES_NO_REGEX) || input.isEmpty();
        }
        boolean confirmed = input.isEmpty() && defaultConfirmation || input.toLowerCase().startsWith("y");
        LOGGER.debug("Confirmation for action '{}', was: {}", (Object)desc, (Object)confirmed);
        return confirmed;
    }

    public void setIn(InputStream in) {
        this.in = in;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    protected void checkConsoleExistence() throws IOException {
        if (System.console() == null) {
            throw new IOException("No Console associated with the current Java virtual machine for interactive user input");
        }
    }
}

