/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.runtime.upgrade.tool.service.api;

import java.io.IOException;
import java.nio.file.Path;

/**
 * This service manages file descriptor's functionalities.
 */
public interface ConfigFilesService {

  boolean checkConflicts(Path oldMule, Path newMule, boolean isDryRunMode) throws IOException;

  void copyFinalConfigFiles(Path oldMule, boolean dryRun) throws IOException;

  Path getResolvedConflictsFolder();

  String getFilesWithConflictsSuffix();
}
