/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.utils;

import java.net.URL;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;

/**
 * Service for loading resources.
 */
@Service
public class ClassLoaderService {

  @Autowired
  ResourceLoader resourceLoader;

  private static final ClassLoader CLASS_LOADER = ClassLoaderService.class.getClassLoader();

  /**
   * Retrieves an specific URL, in case that not exist, return null.
   * 
   * @param filePath Path of the file that we want.
   * @return URL of the file.
   */
  public URL getURLByResourcePath(String filePath) {
    return CLASS_LOADER.getResource(filePath);
  }

  /**
   * Retrieves a resource from the application classpath.
   *
   * @param path Resource path.
   * @return a {@link Resource}.
   */
  public Resource getResourceFromClasspath(String path) {
    return resourceLoader.getResource("classpath:" + path);
  }
}
