/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.service.api.ConfigFilesService;
import com.mulesoft.runtime.upgrade.tool.service.api.FileSystemService;
import com.mulesoft.runtime.upgrade.tool.service.api.MuleDistroService;
import com.mulesoft.runtime.upgrade.tool.service.api.UpgradeConfigService;
import com.mulesoft.runtime.upgrade.tool.utils.ClassLoaderService;
import com.mulesoft.runtime.upgrade.tool.utils.JarFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultConfigFilesService
implements ConfigFilesService {
    @Autowired
    private MuleDistroService muleDistroService;
    @Autowired
    private ClassLoaderService classLoaderService;
    @Autowired
    private FileSystemService fileSystemService;
    @Autowired
    private UpgradeConfigService upgradeConfigService;
    public static final String ORIGINAL_FILES_OLD_DISTRO_FOLDER = "ORIGINAL_CONFIG_FILES_OLD_DISTRO";
    public static final String ORIGINAL_FILES_NEW_DISTRO_FOLDER = "ORIGINAL_CONFIG_FILES_NEW_DISTRO";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfigFilesService.class);
    private static final String CONFIGS_FILES_JAR_NAME_PREFIX = "mule-config-files-";
    private static final String CONFIGS_FILES_JARS_DIRECTORY_INSIDE_UPGRADE_TOOL = "mule-config-files";
    private static final String TO_FIX_SUFFIX = "_TO_FIX";

    public String getFilesWithConflictsSuffix() {
        return TO_FIX_SUFFIX;
    }

    public Path getResolvedConflictsFolder() {
        return Paths.get(this.upgradeConfigService.getUpgradeToolFolderName(), this.upgradeConfigService.getConfigFilesResolvedConflictsFolderName());
    }

    String getConfigsFileJarPath(Path muleHome) throws IOException {
        if (this.checkConfigsFileJarExistenceInsideUpgradeTool(muleHome)) {
            String version = this.muleDistroService.detectMuleVersion(muleHome);
            return this.extractConfigFilesJarFromUpgradeTool(version, muleHome);
        }
        if (this.checkConfigsFileJarExistenceInsideMuleDistro(muleHome)) {
            return this.resolveConfigsFilesJarPathInDistro(muleHome);
        }
        throw new FileNotFoundException("The Configs Jar file was not found neither in the Mule Distribution " + muleHome + " nor inside the upgrade tool configs files jars.");
    }

    String extractConfigFilesJarFromUpgradeTool(String version, Path muleHome) throws IOException {
        Optional configFilesJarURLOptional = this.resolveConfigsFilesJarPathInUpgradeTool(version);
        if (configFilesJarURLOptional.isPresent()) {
            URL configFilesJarURL = (URL)configFilesJarURLOptional.get();
            String configFilesJarName = Paths.get(configFilesJarURL.getPath(), new String[0]).getFileName().toString();
            File destExtractedFile = this.getResolvedConflictsFolderInDistro(muleHome).resolve(configFilesJarName).toFile();
            InputStream jarContent = configFilesJarURL.openStream();
            FileUtils.copyInputStreamToFile((InputStream)jarContent, (File)destExtractedFile);
            return destExtractedFile.getAbsolutePath();
        }
        throw new FileNotFoundException("The Configs Jar file was not found inside the upgrade tool configs files jars.");
    }

    boolean checkConfigsFileJarExistenceInsideUpgradeTool(Path muleHome) throws FileNotFoundException {
        String currentVersion = this.muleDistroService.detectMuleVersion(muleHome);
        return this.checkConfigsFileJarExistenceInsideUpgradeTool(currentVersion);
    }

    boolean configFileIsInResolvedConflictsFolder(Path muleHome, String fileName) {
        return Files.exists(this.getResolvedConflictsFolderInDistro(muleHome).resolve(fileName), new LinkOption[0]);
    }

    public Path getResolvedConflictsFolderInDistro(Path muleHome) {
        return muleHome.resolve(this.getResolvedConflictsFolder());
    }

    boolean checkConfigsFileJarExistenceInsideUpgradeTool(String version) {
        Optional configsFileJarInUpgradeTool = this.resolveConfigsFilesJarPathInUpgradeTool(version);
        return configsFileJarInUpgradeTool.isPresent();
    }

    boolean checkConfigsFileJarExistenceInsideMuleDistro(Path muleHome) throws FileNotFoundException {
        String configsFileJarInDistro = this.resolveConfigsFilesJarPathInDistro(muleHome);
        if (Files.exists(Paths.get(configsFileJarInDistro, new String[0]), new LinkOption[0])) {
            LOGGER.debug("{} file was found inside the distribution.", (Object)configsFileJarInDistro);
            return true;
        }
        LOGGER.debug("{} file was NOT found inside the distribution.", (Object)configsFileJarInDistro);
        return false;
    }

    Optional<URL> resolveConfigsFilesJarPathInUpgradeTool(String version) {
        Path configFilesJarPathInUpgradeTool = Paths.get(CONFIGS_FILES_JARS_DIRECTORY_INSIDE_UPGRADE_TOOL, CONFIGS_FILES_JAR_NAME_PREFIX + version + ".jar");
        URL configsFileJarInsideUpgradeToolURL = this.classLoaderService.getURLByResourcePath(configFilesJarPathInUpgradeTool.toString());
        if (configsFileJarInsideUpgradeToolURL == null) {
            LOGGER.debug("Mule Runtime configs files jar NOT found in upgrade tool under resources path [{}]", (Object)configFilesJarPathInUpgradeTool);
            return Optional.empty();
        }
        LOGGER.debug("Mule Runtime configs files jar found in upgrade tool under resources path [{}]", (Object)configFilesJarPathInUpgradeTool);
        return Optional.of(configsFileJarInsideUpgradeToolURL);
    }

    String resolveConfigsFilesJarPathInDistro(Path muleHome) throws FileNotFoundException {
        String currentVersion = this.muleDistroService.detectMuleVersion(muleHome);
        Path configsFileJarWithVersion = this.muleDistroService.getLibMuleJarDirectoryPath().resolve(CONFIGS_FILES_JAR_NAME_PREFIX + currentVersion + ".jar");
        return muleHome.resolve(configsFileJarWithVersion).toAbsolutePath().toString();
    }

    public boolean checkConflicts(Path oldMule, Path newMule, boolean isDryRunMode) throws IOException {
        String configsFileJarPathInOldDistro;
        String configsFileJarPathInNewDistro;
        LOGGER.debug("Checking Mule Runtime Config files conflicts between distributions [{}] and [{}]...", (Object)oldMule, (Object)newMule);
        if (!this.checkConfigFilesJarsExistencesInsideBothDistributions(oldMule, newMule)) {
            return false;
        }
        LOGGER.debug("Mule Runtime Config files successfully found in both distributions [{}] and [{}]", (Object)oldMule, (Object)newMule);
        try {
            configsFileJarPathInNewDistro = this.getConfigsFileJarPath(newMule);
            configsFileJarPathInOldDistro = this.getConfigsFileJarPath(oldMule);
        }
        catch (FileNotFoundException e) {
            throw new IOException("Upgrading from/to this version caused an unexpected error trying to obtain the Mule Runtime configs files. Please create a ticket to support.", e);
        }
        List configFilesInOldDistroJar = JarFileUtils.getJarEntries((String)configsFileJarPathInOldDistro);
        boolean configFilesCheckIsFine = true;
        for (String configFileNameInOldDistroJar : configFilesInOldDistroJar) {
            byte[] configFileContentInOldDistro = JarFileUtils.getFileContentInByteArray((String)configsFileJarPathInOldDistro, (String)configFileNameInOldDistroJar);
            byte[] configFileContentInNewDistro = JarFileUtils.getFileContentInByteArray((String)configsFileJarPathInNewDistro, (String)configFileNameInOldDistroJar);
            if (this.configFileIsInResolvedConflictsFolder(oldMule, configFileNameInOldDistroJar)) continue;
            if (this.configFileHasConflicts(configFileContentInOldDistro, configFileContentInNewDistro)) {
                if (!isDryRunMode) {
                    this.copyUserConfigFileWithConflictsAddingToFixSuffix(oldMule, configFileNameInOldDistroJar);
                    this.copyOriginalConfigFilesInConflictsFolderAsReference(oldMule, newMule, configFileContentInOldDistro, configFileContentInNewDistro, configFileNameInOldDistroJar);
                }
                String errorMessage = "The config file '{}' was updated in the new version, make sure the one you want to use with the changes needed is in [{}] to be used during the upgrade command.";
                LOGGER.error(errorMessage, (Object)configFileNameInOldDistroJar, (Object)this.getResolvedConflictsFolderInDistro(oldMule).resolve(configFileNameInOldDistroJar));
                configFilesCheckIsFine = false;
                continue;
            }
            if (isDryRunMode) continue;
            this.copyUserConfigFileWoutConflicts(oldMule, configFileNameInOldDistroJar);
        }
        return configFilesCheckIsFine;
    }

    private void copyUserConfigFileWoutConflicts(Path muleHome, String configFileName) throws IOException {
        File sourceFile = muleHome.resolve(configFileName).toFile();
        File destFile = this.getResolvedConflictsFolderInDistro(muleHome).resolve(this.muleDistroService.getConfigFolder()).toFile();
        FileUtils.copyFileToDirectory((File)sourceFile, (File)destFile);
    }

    private void copyUserConfigFileWithConflictsAddingToFixSuffix(Path muleHome, String configFileName) throws IOException {
        File sourceFile = muleHome.resolve(configFileName).toFile();
        File destFile = this.getResolvedConflictsFolderInDistro(muleHome).resolve(configFileName + TO_FIX_SUFFIX).toFile();
        FileUtils.copyFile((File)sourceFile, (File)destFile);
    }

    private void copyOriginalConfigFilesInConflictsFolderAsReference(Path muleHomeOld, Path muleHomeNew, byte[] oldConfigFileContent, byte[] newConfigFileContent, String configFileName) throws IOException {
        File destFileOldDistro = this.getResolvedConflictsFolderInDistro(muleHomeOld).resolve("ORIGINAL_CONFIG_FILES_OLD_DISTRO-" + muleHomeOld.getFileName()).resolve(configFileName).toFile();
        File destFileNewDistro = this.getResolvedConflictsFolderInDistro(muleHomeOld).resolve("ORIGINAL_CONFIG_FILES_NEW_DISTRO-" + muleHomeNew.getFileName()).resolve(configFileName).toFile();
        FileUtils.writeByteArrayToFile((File)destFileOldDistro, (byte[])oldConfigFileContent);
        FileUtils.writeByteArrayToFile((File)destFileNewDistro, (byte[])newConfigFileContent);
    }

    private boolean configFileHasConflicts(byte[] configFileContentInOldDistro, byte[] configFileContentInNewDistro) throws IOException {
        return !this.fileSystemService.areHashesBetweenFilesEqual(configFileContentInOldDistro, configFileContentInNewDistro);
    }

    boolean checkConfigFilesJarsExistencesInsideBothDistributions(Path oldMulePath, Path newMulePath) throws FileNotFoundException {
        LOGGER.debug("Checking mule-config-files jar existence...");
        return this.checkConfigsFileJarExistenceInsideMuleDistroOrInsideUpgradeTool(oldMulePath) && this.checkConfigsFileJarExistenceInsideMuleDistroOrInsideUpgradeTool(newMulePath);
    }

    boolean checkConfigsFileJarExistenceInsideMuleDistroOrInsideUpgradeTool(Path muleHome) throws FileNotFoundException {
        return this.checkConfigsFileJarExistenceInsideMuleDistro(muleHome) || this.checkConfigsFileJarExistenceInsideUpgradeTool(muleHome);
    }

    public void copyFinalConfigFiles(Path oldMule, boolean isDryRunMode) throws IOException {
        Path resolvedConflictsFolder = this.getResolvedConflictsFolderInDistro(oldMule);
        LOGGER.debug("Copying mule runtime distribution config files from [{}] to [{}].", (Object)resolvedConflictsFolder.resolve(this.muleDistroService.getConfigFolder()), (Object)oldMule.resolve(this.muleDistroService.getConfigFolder()));
        ArrayList<Path> includedPaths = new ArrayList<Path>();
        includedPaths.add(this.muleDistroService.getConfigFolder());
        ArrayList excludedPaths = new ArrayList();
        this.fileSystemService.copyFiles(resolvedConflictsFolder, oldMule, includedPaths, excludedPaths, isDryRunMode);
        if (!isDryRunMode) {
            FileUtils.deleteDirectory((File)resolvedConflictsFolder.toFile());
        }
    }
}

