/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.utils;

import com.mulesoft.runtime.upgrade.tool.domain.BackupDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class PrettyPrintingFormatter {
    private PrettyPrintingFormatter() {
        throw new IllegalStateException("Utility class");
    }

    public static String formatBackupDescriptor(BackupDescriptor backupDescriptor) {
        ArrayList<String> formattedLines = new ArrayList<String>();
        formattedLines.add("*** Backup metadata:");
        formattedLines.add(String.format("- Generation timestamp: %s", backupDescriptor.getBackupGenerationTimestamp()));
        formattedLines.add(String.format("- Upgrade tool version: %s", backupDescriptor.getUpgradeToolVersion()));
        formattedLines.add(String.format("- Mule Runtime distribution version: %s", backupDescriptor.getMuleRuntimeDistributionVersion()));
        return PrettyPrintingFormatter.prettify(formattedLines);
    }

    public static String formatStatusCommandMessage(List<String> messages) {
        ArrayList<String> formattedLines = new ArrayList<String>();
        formattedLines.add("*** STATUS:");
        formattedLines.addAll(messages);
        return PrettyPrintingFormatter.prettify(formattedLines);
    }

    public static String formatAppliedPatches(List<File> appliedPatches) {
        ArrayList<String> formattedLines = new ArrayList<String>();
        formattedLines.add("*** Applied patches list:");
        appliedPatches.forEach(file -> formattedLines.add(String.format("- %s", file.getName())));
        return PrettyPrintingFormatter.prettify(formattedLines);
    }

    private static String prettify(List<String> formattedLines) {
        int maxLineLength = formattedLines.stream().max(Comparator.comparingInt(String::length)).orElseGet(String::new).length();
        String lineSeparator = String.format("*** %s%n", IntStream.rangeClosed(0, maxLineLength - 4).mapToObj(x -> "*").collect(Collectors.joining()));
        StringBuilder builder = new StringBuilder();
        builder.append(lineSeparator);
        builder.append(String.format("%s%n", formattedLines.get(0)));
        builder.append(lineSeparator);
        formattedLines.stream().skip(1L).forEach(str -> builder.append(String.format("%s%n", str)));
        builder.append(lineSeparator);
        return builder.toString();
    }
}

