/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.command;

import static picocli.CommandLine.IExecutionExceptionHandler;
import static picocli.CommandLine.ParseResult;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

/**
 * This class handles any exception which happened during the execution of the tool.
 */
@Component
public class ExecutionExceptionHandler implements IExecutionExceptionHandler {

  private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionExceptionHandler.class);

  @Override
  public int handleExecutionException(Exception ex, CommandLine cmd, ParseResult parseResult) throws Exception {
    if (LOGGER.isDebugEnabled()) {
      LOGGER.error(ex.getMessage(), ex);
    } else {
      LOGGER.error(ex.getMessage());
    }

    // bold red error message
    cmd.getErr().println(cmd.getColorScheme().errorText(ex.getMessage()));

    return cmd.getExitCodeExceptionMapper() != null
        ? cmd.getExitCodeExceptionMapper().getExitCode(ex)
        : cmd.getCommandSpec().exitCodeOnExecutionException();
  }
}
