/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.command;

import static com.mulesoft.runtime.upgrade.tool.service.DefaultRollbackService.USER_REJECTED_TO_PROCEED_WITH_THE_ROLLBACK_PROCESS_MESSAGE;
import static com.mulesoft.runtime.upgrade.tool.service.DefaultUpgradeService.USER_REJECTED_TO_PROCEED_WITH_THE_UPGRADE_PROCESS_MESSAGE;

import org.springframework.stereotype.Component;
import picocli.CommandLine.IExitCodeExceptionMapper;

/**
 * Implementation of {@link IExitCodeExceptionMapper} to meet the mapping exit code business rules of the runtime upgrade tool
 * commands.
 */
@Component
public class ExitCodeExceptionMapper implements IExitCodeExceptionMapper {

  @Override
  public int getExitCode(Throwable exception) {
    if (exception instanceof IllegalStateException
        && (USER_REJECTED_TO_PROCEED_WITH_THE_ROLLBACK_PROCESS_MESSAGE.equals(exception.getMessage())
            || USER_REJECTED_TO_PROCEED_WITH_THE_UPGRADE_PROCESS_MESSAGE.equals(exception.getMessage()))) {
      // ref: Inspired on Bash exit codes: `Command invoked cannot execute`. https://tldp.org/LDP/abs/html/exitcodes.html
      return 126;
    }
    return 1;
  }
}
