/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.domain;

import java.time.Instant;
import java.util.List;

/**
 * This class provides information about the backup generated after executing the tool.
 */
public class BackupDescriptor {

  private Instant backupGenerationTimestamp;

  private String upgradeToolVersion;

  private String muleRuntimeDistributionVersion;

  private List<AssemblyEntry> backupEntries;

  public static Builder builder() {
    return new Builder();
  }

  public BackupDescriptor() {}

  protected BackupDescriptor(Instant backupGenerationTimestamp, String upgradeToolVersion,
                             String muleRuntimeDistributionVersion, List<AssemblyEntry> backupEntries) {
    this.backupGenerationTimestamp = backupGenerationTimestamp;
    this.upgradeToolVersion = upgradeToolVersion;
    this.muleRuntimeDistributionVersion = muleRuntimeDistributionVersion;
    this.backupEntries = backupEntries;
  }

  public Instant getBackupGenerationTimestamp() {
    return backupGenerationTimestamp;
  }

  public String getUpgradeToolVersion() {
    return upgradeToolVersion;
  }

  public String getMuleRuntimeDistributionVersion() {
    return muleRuntimeDistributionVersion;
  }

  public List<AssemblyEntry> getBackupEntries() {
    return backupEntries;
  }

  public static class Builder {

    private Instant backupGenerationTimestamp;
    private String upgradeToolVersion;
    private String muleRuntimeDistributionVersion;
    private List<AssemblyEntry> backupEntries;

    public Builder backupGenerationTimestamp(Instant backupGenerationTimestamp) {
      this.backupGenerationTimestamp = backupGenerationTimestamp;
      return this;
    }

    public Builder upgradeToolVersion(String upgradeToolVersion) {
      this.upgradeToolVersion = upgradeToolVersion;
      return this;
    }

    public Builder muleRuntimeDistributionVersion(String muleRuntimeDistributionVersion) {
      this.muleRuntimeDistributionVersion = muleRuntimeDistributionVersion;
      return this;
    }

    public Builder backupEntries(List<AssemblyEntry> backupEntries) {
      this.backupEntries = backupEntries;
      return this;
    }

    public BackupDescriptor build() {
      return new BackupDescriptor(backupGenerationTimestamp, upgradeToolVersion, muleRuntimeDistributionVersion, backupEntries);
    }
  }

}
