/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.domain;

import java.nio.file.Path;

/**
 * This class provides the location and the version of the current mule distribution.
 */
public class MuleDistribution {

  private final Path location;
  private final SemVer version;

  public MuleDistribution(Path location, String version) {
    this.location = location;
    this.version = SemVer.valueOf(version);
  }

  public static Builder builder() {
    return new Builder();
  }

  public Path getLocation() {
    return location;
  }

  public SemVer getVersion() {
    return version;
  }

  public static class Builder {

    private Path location;
    private String version;

    public Builder location(Path location) {
      this.location = location;
      return this;
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public MuleDistribution build() {
      return new MuleDistribution(location, version);
    }
  }
}
