/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.service.utils;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;

import com.mulesoft.runtime.upgrade.tool.domain.enums.PathToBeAdditionallyBackedUp;
import com.mulesoft.runtime.upgrade.tool.domain.enums.PathToBeReplaced;

import java.nio.file.Path;
import java.util.List;

/**
 * Utils class for easing the treatment of enums where paths involved in the upgrade process are defined.
 */
public class PathDefinitionUtils {

  public PathDefinitionUtils() {
    // sonarqube RSPEC-1118
    throw new IllegalStateException("Utility class");
  }

  /**
   * Get the list of all defined paths that are involved in the upgrade process. This includes {@link PathToBeReplaced} and
   * {@link PathToBeAdditionallyBackedUp}.
   *
   * @return the list of all defined paths that are impacted by the upgrade process.
   */
  public static List<Path> getAllDefinedPaths() {
    return concat(PathToBeReplaced.getAllPaths().stream(), PathToBeAdditionallyBackedUp.getAllPaths().stream())
        .collect(toList());
  }
}
