/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.domain.enums.FileToBeExcluded;
import com.mulesoft.runtime.upgrade.tool.service.api.FileSystemService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultFileSystemService
implements FileSystemService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileSystemService.class);
    public static final double REQUIRED_DISK_SPACE_SLACK_MULTIPLIER = 1.1;

    public void checkIsADirectory(Path path) throws NotDirectoryException {
        LOGGER.debug("Validating path [{}] is a directory", (Object)path);
        if (!path.toFile().isDirectory()) {
            throw new NotDirectoryException(String.format("Given path [%s] is not a directory", path));
        }
    }

    public void checkWritingAccess(Path parentPath, List<Path> relativePaths) throws IOException {
        LOGGER.debug("Checking writing access for path: {}", (Object)parentPath);
        this.checkWritable(parentPath);
        for (Path relativePath : relativePaths) {
            Path resolvedPath = parentPath.resolve(relativePath);
            this.checkWritable(resolvedPath);
            Stream<Path> fileTree = Files.walk(resolvedPath, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                for (Path treePath : fileTree.collect(Collectors.toList())) {
                    this.checkWritable(treePath);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileTree == null) continue;
                if (throwable != null) {
                    try {
                        fileTree.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fileTree.close();
            }
        }
    }

    private void checkWritable(Path treePath) throws AccessDeniedException {
        if (!Files.isWritable(treePath)) {
            throw new AccessDeniedException(treePath.toString());
        }
    }

    public void checkReadingAccess(Path parentPath, List<Path> relativePaths) throws IOException {
        LOGGER.debug("Checking reading access for path: {}", (Object)parentPath);
        this.checkReadable(parentPath);
        for (Path relativePath : relativePaths) {
            Path resolvedPath = parentPath.resolve(relativePath);
            this.checkReadable(resolvedPath);
            Stream<Path> fileTree = Files.walk(resolvedPath, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                for (Path treePath : fileTree.collect(Collectors.toList())) {
                    this.checkReadable(treePath);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileTree == null) continue;
                if (throwable != null) {
                    try {
                        fileTree.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fileTree.close();
            }
        }
    }

    private void checkReadable(Path treePath) throws AccessDeniedException {
        if (!Files.isReadable(treePath)) {
            throw new AccessDeniedException(treePath.toString());
        }
    }

    public void checkEnoughUsableSpace(Path oldMule, Path newMule, List<Path> paths) throws IOException {
        LOGGER.debug("Checking if there's enough usable space for the upgrade from [{}] to [{}]", (Object)oldMule, (Object)newMule);
        this.checkExistenceOfFilesInvolvedInTheUpgrade(oldMule, newMule, paths);
        long bytesRequiredToCopyNewFiles = this.getSumOfBytesTakenByPathsInDistro(newMule, paths);
        long bytesRequiredForBackup = this.getSumOfBytesTakenByPathsInDistro(oldMule, paths);
        long biggestRequiredSpace = bytesRequiredToCopyNewFiles > bytesRequiredForBackup ? bytesRequiredToCopyNewFiles : bytesRequiredForBackup;
        long requiredSpace = (long)((double)biggestRequiredSpace * 1.1);
        String requiredSpaceHumanFriendly = FileUtils.byteCountToDisplaySize((long)requiredSpace);
        LOGGER.debug("The space required for the upgrade is around: {}", (Object)requiredSpaceHumanFriendly);
        long usableSpace = this.getUsableSpace(oldMule);
        String usableSpaceHumanFriendly = FileUtils.byteCountToDisplaySize((long)usableSpace);
        LOGGER.debug("The usable space: {}", (Object)usableSpaceHumanFriendly);
        if (usableSpace <= requiredSpace) {
            throw new IOException(String.format("Not enough space for the upgrade. Required: %s - Usable: %s", requiredSpace, usableSpace));
        }
    }

    public boolean isWindowsOs() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public void copyFiles(Path srcDir, Path destDir, List<Path> paths, List<Path> excludedPathsArg, boolean isDryRunMode) throws IOException {
        LinkedList excludedPaths = new LinkedList();
        excludedPathsArg.forEach(excludePath -> excludedPaths.add(srcDir.resolve((Path)excludePath)));
        for (Path path : paths) {
            File source = srcDir.resolve(path).toFile();
            File dest = destDir.resolve(path).toFile();
            if (excludedPaths.contains(source.toPath())) continue;
            if (path.toString().equals("conf")) {
                this.copyDistroConfFolder(srcDir, path, dest, isDryRunMode);
                continue;
            }
            this.copyFolderOrFile(source, dest, isDryRunMode);
        }
    }

    void copyDistroConfFolder(Path distroDir, Path path, File dest, boolean isDryRunMode) throws IOException {
        File[] files;
        if (!dest.exists()) {
            dest.mkdir();
        }
        for (File confFiles : files = distroDir.resolve(path).toFile().listFiles()) {
            if (FilenameUtils.getExtension((String)confFiles.getName()).equals("lic")) continue;
            this.copyFolderOrFile(confFiles, dest.toPath().resolve(confFiles.getName()).toFile(), isDryRunMode);
        }
    }

    void copyFolderOrFile(File source, File dest, boolean isDryRunMode) throws IOException {
        if (source.isDirectory()) {
            this.copyDir(source, dest, isDryRunMode);
        } else {
            this.copyFile(source, dest, isDryRunMode);
        }
    }

    void checkExistenceOfFilesInvolvedInTheUpgrade(Path oldMule, Path newMule, List<Path> paths) throws FileNotFoundException {
        this.checkNoMissingFileInDistro(oldMule, paths);
        this.checkNoMissingFileInDistro(newMule, paths);
    }

    void checkNoMissingFileInDistro(Path distroHome, List<Path> expectedPathsInDistro) throws FileNotFoundException {
        LOGGER.debug("Checking expected paths [{}] in Mule distro [{}]", expectedPathsInDistro, (Object)distroHome);
        List missingPaths = expectedPathsInDistro.stream().filter(path -> !distroHome.resolve((Path)path).toFile().exists()).collect(Collectors.toList());
        if (!missingPaths.isEmpty()) {
            String joinedMissingPaths = missingPaths.stream().map(path -> distroHome.resolve((Path)path).toString()).collect(Collectors.joining(","));
            throw new FileNotFoundException(String.format("Expected files in distribution were not found: %s", joinedMissingPaths));
        }
    }

    private long getSumOfBytesTakenByPathsInDistro(Path distroHome, List<Path> pathsInvolvedInTheUpgrade) {
        long sumOfSpaceTakenByFiles = pathsInvolvedInTheUpgrade.stream().mapToLong(path -> FileUtils.sizeOf((File)distroHome.resolve((Path)path).toFile())).sum();
        String spaceTakenByFilesHumanFriendly = FileUtils.byteCountToDisplaySize((long)sumOfSpaceTakenByFiles);
        LOGGER.debug("Paths involved in the upgrade [{}] take: {}", pathsInvolvedInTheUpgrade, (Object)spaceTakenByFilesHumanFriendly);
        return sumOfSpaceTakenByFiles;
    }

    long getUsableSpace(Path path) {
        return path.toFile().getUsableSpace();
    }

    private void copyDir(File source, File dest, boolean isDryRunMode) throws IOException {
        if (dest.exists()) {
            LOGGER.debug("Deleting dir [{}] content...", (Object)dest);
            if (!isDryRunMode) {
                FileUtils.deleteDirectory((File)dest);
            }
        }
        LOGGER.debug("Copying dir [{}] content to [{}]...", (Object)source, (Object)dest);
        if (!isDryRunMode) {
            FileUtils.copyDirectory((File)source, (File)dest);
        }
    }

    private void copyFile(File source, File dest, boolean isDryRunMode) throws IOException {
        if (dest.exists()) {
            LOGGER.debug("Deleting file [{}]...", (Object)dest);
            if (!isDryRunMode) {
                Files.delete(dest.toPath());
            }
        }
        LOGGER.debug("Copying file [{}] to [{}]...", (Object)source, (Object)dest);
        if (!isDryRunMode) {
            FileUtils.copyFile((File)source, (File)dest);
        }
    }

    public void deleteFilesInsideADistro(Path distroPath, List<String> fileNamesList, boolean isDryRunMode) throws IOException {
        for (String file : fileNamesList) {
            Path filePath = Paths.get(file, new String[0]);
            Path fileToDelete = distroPath.resolve(filePath);
            if (!this.isValidFile(filePath, distroPath) || !fileToDelete.toFile().exists()) continue;
            LOGGER.debug("Deleting file [{}]...", (Object)fileToDelete);
            if (isDryRunMode) continue;
            Files.delete(fileToDelete);
        }
    }

    public void copyFilesInsideADistro(Path sourceMuleDistroPath, Path destMuleDistroPath, List<String> fileNamesList, boolean isDryRunMode) throws IOException {
        for (String file : fileNamesList) {
            Path filePath = Paths.get(file, new String[0]);
            if (!this.isValidFile(filePath, sourceMuleDistroPath)) continue;
            Path source = sourceMuleDistroPath.resolve(filePath);
            Path dest = destMuleDistroPath.resolve(filePath);
            LOGGER.debug("Copying file [{}] to [{}]...", (Object)source, (Object)dest);
            if (isDryRunMode) continue;
            FileUtils.copyFile((File)source.toFile(), (File)dest.toFile());
        }
    }

    public boolean isValidFile(Path filePath, Path srcDir) {
        int firstDirectoryLevelInsideMuleDistro;
        LinkedList excludedPaths = new LinkedList();
        String[] filePathArray = filePath.toString().split(Pattern.quote(File.separator));
        if (filePathArray.length > (firstDirectoryLevelInsideMuleDistro = 1)) {
            String fileDir = filePathArray[0];
            String directChildInsideFileDir = filePathArray[1];
            FileToBeExcluded.getAllPaths().forEach(excludePath -> excludedPaths.add(srcDir.resolve((Path)excludePath)));
            File source = srcDir.resolve(filePath).toFile();
            return !excludedPaths.contains(source.toPath()) && (!fileDir.equals("conf") || !FilenameUtils.getExtension((String)directChildInsideFileDir).equals("lic"));
        }
        return true;
    }

    public boolean areHashesBetweenFilesEqual(Path fileA, Path fileB) throws IOException {
        return this.getSha256(fileA).equals(this.getSha256(fileB));
    }

    public boolean areHashesBetweenFilesEqual(byte[] fileContentA, byte[] fileContentB) throws IOException {
        return this.getSha256(fileContentA).equals(this.getSha256(fileContentB));
    }

    public String getSha256(Path filePath) throws IOException {
        return this.getSha256(Files.newInputStream(filePath, new OpenOption[0]));
    }

    public String getSha256(InputStream stream) throws IOException {
        return DigestUtils.sha256Hex((InputStream)stream);
    }

    public String getSha256(byte[] content) {
        return DigestUtils.sha256Hex((byte[])content);
    }
}

