/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.domain.BackupDescriptor;
import com.mulesoft.runtime.upgrade.tool.domain.MuleDistribution;
import com.mulesoft.runtime.upgrade.tool.service.api.BackupService;
import com.mulesoft.runtime.upgrade.tool.service.api.MuleDistroService;
import com.mulesoft.runtime.upgrade.tool.service.api.StatusPreconditionsValidatorService;
import com.mulesoft.runtime.upgrade.tool.service.api.StatusService;
import com.mulesoft.runtime.upgrade.tool.utils.PrettyPrintingFormatter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultStatusService
implements StatusService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStatusService.class);
    @Autowired
    private MuleDistroService distroService;
    @Autowired
    private StatusPreconditionsValidatorService statusPreconditionsValidatorService;
    @Autowired
    private BackupService backupService;
    private static final String UPGRADE_MESSAGE = "For upgrading: java -jar mule-runtime-upgrade-tool-1.0.0-SNAPSHOT.jar upgrade -o %s -n [\"New Mule Runtime Distribution Path\"]";
    private static final String ROLLBACK_MESSAGE = "For rolling back: java -jar mule-runtime-upgrade-tool-1.0.0-SNAPSHOT.jar rollback -o %s";
    private static final int NO_ERRORS_LIST_SIZE = 1;

    public void statusCommandExecute(Path oldMule) throws IOException {
        LinkedList<String> messagesToPrint = new LinkedList<String>();
        List upgradeMessages = this.preconditionUpgradeStatus(oldMule);
        List rollbackMessages = this.preconditionRollbackStatus(oldMule);
        boolean upgradePreconditionsMet = upgradeMessages.size() == 1;
        boolean rollbackPreconditionsMet = rollbackMessages.size() == 1;
        String backupPrettyFormat = "";
        String currentMuleDistroVersion = this.distroService.detectMuleVersion(oldMule);
        messagesToPrint.add("The current Mule Distribution version is " + currentMuleDistroVersion);
        if (this.distroService.checkClusterModeIsActive(oldMule)) {
            messagesToPrint.add("Mule Runtime Distribution is running in cluster mode.");
        }
        LinkedList<String> optionsMessages = new LinkedList<String>();
        if (upgradePreconditionsMet || rollbackPreconditionsMet) {
            optionsMessages.add("Possibles commands to execute:");
            if (upgradePreconditionsMet) {
                optionsMessages.add(String.format("------For upgrading: java -jar mule-runtime-upgrade-tool-1.0.0-SNAPSHOT.jar upgrade -o %s -n [\"New Mule Runtime Distribution Path\"]", oldMule));
            }
            if (rollbackPreconditionsMet) {
                optionsMessages.add(String.format("------For rolling back: java -jar mule-runtime-upgrade-tool-1.0.0-SNAPSHOT.jar rollback -o %s", oldMule));
                Optional backupDescriptor = this.backupService.readBackupDescriptor(oldMule);
                if (backupDescriptor.isPresent()) {
                    backupPrettyFormat = String.format("%n%s", PrettyPrintingFormatter.formatBackupDescriptor((BackupDescriptor)((BackupDescriptor)backupDescriptor.get())));
                }
            }
        }
        if (upgradePreconditionsMet) {
            upgradeMessages.add("All the upgrade process preconditions were met.");
            if (this.distroService.checkMisleadingMuleDirName(oldMule)) {
                LOGGER.warn("A version in your MULE_HOME directory name was detected: {}, beware it may not match the current installed version inside the directory.", (Object)oldMule);
            }
        } else {
            upgradeMessages.add("Not all the upgrade process preconditions were met.");
        }
        if (rollbackPreconditionsMet) {
            rollbackMessages.add("All the rollback process preconditions were met.");
        } else {
            rollbackMessages.add("Not all the rollback process preconditions were met.");
        }
        messagesToPrint.addAll(upgradeMessages);
        messagesToPrint.addAll(rollbackMessages);
        messagesToPrint.addAll(optionsMessages);
        String textToPrint = PrettyPrintingFormatter.formatStatusCommandMessage(messagesToPrint);
        LOGGER.info(String.format("%n%s", textToPrint + backupPrettyFormat));
    }

    public List<String> preconditionUpgradeStatus(Path oldMule) throws IOException {
        LOGGER.info("Checking upgrade preconditions...");
        LinkedList<String> upgradeMessages = new LinkedList<String>();
        MuleDistribution oldDistro = this.distroService.initMuleDistro(oldMule);
        upgradeMessages.addAll(this.statusPreconditionsValidatorService.checkUpgradeStatusOffline(oldDistro));
        if (upgradeMessages.size() == 1) {
            LOGGER.info("All preconditions were met for upgrade process.");
        } else {
            LOGGER.error("Not all preconditions were met for upgrading process.");
        }
        return upgradeMessages;
    }

    public List<String> preconditionRollbackStatus(Path currentMule) throws IOException {
        LOGGER.info("Checking rollback preconditions...");
        LinkedList<String> rollbackMessages = new LinkedList<String>();
        rollbackMessages.add("Checking rollback process preconditions...");
        rollbackMessages.addAll(this.statusPreconditionsValidatorService.checkRollbackPreconditions(currentMule));
        if (rollbackMessages.size() == 1) {
            LOGGER.info("All preconditions were met for rolling back process.");
        }
        return rollbackMessages;
    }
}

