/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.domain;

/**
 * A class that encapsulates all the common config options for processes.
 */
public class CommandOptions {

  boolean force;
  boolean dryRun;

  public CommandOptions() {}

  public CommandOptions(boolean force, boolean dryRun) {
    this.force = force;
    this.dryRun = dryRun;
  }

  public static Builder builder() {
    return new Builder();
  }

  public boolean isForce() {
    return force;
  }

  public boolean isDryRun() {
    return dryRun;
  }

  public static class Builder {

    private boolean force;
    private boolean dryRun;

    public Builder force(boolean force) {
      this.force = force;
      return this;
    }

    public Builder dryRun(boolean dryRun) {
      this.dryRun = dryRun;
      return this;
    }

    public CommandOptions build() {
      return new CommandOptions(force, dryRun);
    }
  }
}
