/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.service.api;

import com.mulesoft.runtime.upgrade.tool.domain.MuleDistribution;

import java.io.IOException;
import java.nio.file.Path;

/**
 * A preconditions validator for the tool main processes.
 */
public interface PreconditionsValidatorService {

  /**
   * Checks that all preconditions for performing the upgrade are met.
   *
   * @param oldMule {@link MuleDistribution} representing the old Mule Runtime distribution being upgraded.
   * @param newMule {@link MuleDistribution} representing the new Mule Runtime distribution used for the upgrade.
   * @param force   whether explicit consent has been provided for the override related preconditions like the ones for the backup
   *                and applied patches.
   *
   * @throws IllegalStateException if validations are not met.
   * @throws IOException           if an I/O error occurs.
   */
  void checkUpgradeReadiness(MuleDistribution oldMule, MuleDistribution newMule, boolean force, boolean isDryRun)
      throws IOException;

  /**
   * Checks that all preconditions for performing the rollback are met.
   *
   * @param muleDistroLocation location of the Mule Runtime distribution being validated for rollback process.
   *
   * @throws IllegalStateException if validations are not met.
   * @throws IOException           if an I/O error occurs.
   */
  void checkRollbackReadiness(Path muleDistroLocation) throws IOException;

  /**
   * Asks consent for overwriting the current BackUp.
   * 
   * @param distroLocation Mule Runtime Distribution Path.
   * @param force          If force is true, will not ask to the user.
   * @return Yes if user answered yes or is running in force mode, No in other case.
   * @throws IOException
   */
  boolean getConsentForOverwritingBackup(Path distroLocation, boolean force) throws IOException;
}
