/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.service.api.UpgradeConfigService;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * Service for loading upgrade tool configuration.
 */
@Component
@ConfigurationProperties(prefix = "upgrade")
public class DefaultUpgradeConfigService implements UpgradeConfigService {

  private String upgradeToolUpgradeFilesFolder;

  private String configFilesResolvedConflictsFolder;

  private String backupFolderWithinUpgradingMule;

  private String backupDescriptorFileName;

  private String docsPage;

  private String docsSolveConfigConflictsSection;

  @Override
  public String getUpgradeToolFolderName() {
    return upgradeToolUpgradeFilesFolder;
  }

  @Override
  public String getConfigFilesResolvedConflictsFolderName() {
    return configFilesResolvedConflictsFolder;
  }

  @Override
  public String getBackupFolderName() {
    return backupFolderWithinUpgradingMule;
  }

  @Override
  public String getBackupDescriptorFileName() {
    return backupDescriptorFileName;
  }

  @Override
  public String getDocsPage() {
    return docsPage;
  }

  @Override
  public String getDocsSolveConfigConflictsSection() {
    return docsSolveConfigConflictsSection;
  }

  public void setUpgradeToolUpgradeFilesFolder(String upgradeToolUpgradeFilesFolder) {
    this.upgradeToolUpgradeFilesFolder = upgradeToolUpgradeFilesFolder;
  }

  public void setConfigFilesResolvedConflictsFolder(String configFilesResolvedConflictsFolder) {
    this.configFilesResolvedConflictsFolder = configFilesResolvedConflictsFolder;
  }

  public void setBackupFolderWithinUpgradingMule(String backupFolderWithinUpgradingMule) {
    this.backupFolderWithinUpgradingMule = backupFolderWithinUpgradingMule;
  }

  public void setBackupDescriptorFileName(String backupDescriptorFileName) {
    this.backupDescriptorFileName = backupDescriptorFileName;
  }

  public void setDocsPage(String docsPage) {
    this.docsPage = docsPage;
  }

  public void setDocsSolveConfigConflictsSection(String docsSolveConfigConflictsSection) {
    this.docsSolveConfigConflictsSection = docsSolveConfigConflictsSection;
  }

}
