/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.upgrade.tool.service.api;


import java.io.File;
import java.io.IOException;

/**
 * Service for marshalling and unmarshalling of values in YAML format.
 */
public interface YamlService {

  /**
   * Serializes any Java value as YAML in the given file.
   *
   * @param resultFile output file.
   * @param object     object value.
   *
   * @throws IOException If serialization operation fails.
   */
  void writeValueToFile(File resultFile, Object object) throws IOException;

  /**
   * Deserializes a YAML value to a Java one from a given file.
   *
   * @param src       the source file.
   * @param valueType the class of the output value type.
   * @return
   * @throws IOException if a low-level I/O problem occurs while deserializing the YAML value.
   */
  <T> T readValue(File src, Class<T> valueType) throws IOException;
}
