/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.upgrade.tool.service;

import com.mulesoft.runtime.upgrade.tool.domain.BackupDescriptor;
import com.mulesoft.runtime.upgrade.tool.domain.MuleDistribution;
import com.mulesoft.runtime.upgrade.tool.domain.enums.FileToBeExcluded;
import com.mulesoft.runtime.upgrade.tool.service.api.AppService;
import com.mulesoft.runtime.upgrade.tool.service.api.BackupService;
import com.mulesoft.runtime.upgrade.tool.service.api.DescriptorService;
import com.mulesoft.runtime.upgrade.tool.service.api.FileSystemService;
import com.mulesoft.runtime.upgrade.tool.service.api.PreconditionsValidatorService;
import com.mulesoft.runtime.upgrade.tool.service.api.UpgradeConfigService;
import com.mulesoft.runtime.upgrade.tool.service.api.YamlService;
import com.mulesoft.runtime.upgrade.tool.service.utils.PathDefinitionUtils;
import com.mulesoft.runtime.upgrade.tool.utils.PrettyPrintingFormatter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultBackupService
implements BackupService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBackupService.class);
    @Autowired
    private AppService appService;
    @Autowired
    private UpgradeConfigService upgradeConfigService;
    @Autowired
    private YamlService yamlService;
    @Autowired
    private FileSystemService fileSystemService;
    @Autowired
    private DescriptorService descriptorService;
    @Autowired
    private PreconditionsValidatorService preconditionsValidatorService;
    private Clock clock;

    public void create(MuleDistribution muleDistribution, boolean force, boolean isDryRunMode) throws IOException {
        this.create(muleDistribution, PathDefinitionUtils.getAllDefinedPaths(), FileToBeExcluded.getAllPaths(), force, isDryRunMode);
    }

    private void create(MuleDistribution muleDistribution, List<Path> relativePathOfFilesToBeBackedUp, List<Path> relativePathOfFilesToBeExcluded, boolean force, boolean isDryRunMode) throws IOException {
        LOGGER.debug("Creating backup for distro: {}", (Object)muleDistribution);
        Path muleLocation = muleDistribution.getLocation();
        try {
            if (!this.preconditionsValidatorService.getConsentForOverwritingBackup(muleLocation, force)) {
                throw new IllegalStateException("Consent is needed for overriding current backup.");
            }
            this.purgeBackupDir(muleLocation, isDryRunMode);
            Path backupDestDir = this.getBackupDestDir(muleLocation);
            this.fileSystemService.copyFiles(muleLocation, backupDestDir, relativePathOfFilesToBeBackedUp, relativePathOfFilesToBeExcluded, isDryRunMode);
            this.generateDescriptor(muleDistribution, backupDestDir, isDryRunMode);
        }
        catch (IOException e) {
            this.deleteBackupFolder(muleLocation, isDryRunMode);
            throw new IOException("Backup creation failed.", e);
        }
    }

    public Optional<BackupDescriptor> readBackupDescriptor(Path muleDistributionHome) throws IOException {
        LOGGER.debug("Reading backup descriptor...");
        File yamlDescriptor = this.getBackupDescriptorPathForDistro(muleDistributionHome).toFile();
        if (!yamlDescriptor.exists()) {
            LOGGER.debug("No backup descriptor found");
            return Optional.empty();
        }
        return Optional.of(this.yamlService.readValue(yamlDescriptor, BackupDescriptor.class));
    }

    public boolean checkIntegrity(Path muleDistributionHome) throws IOException {
        LOGGER.debug("Checking backup integrity...");
        Optional backupDescriptor = this.readBackupDescriptor(muleDistributionHome);
        if (backupDescriptor.isPresent()) {
            return this.descriptorService.checkIntegrity(((BackupDescriptor)backupDescriptor.get()).getBackupEntries(), this.getBackupDestDir(muleDistributionHome));
        }
        LOGGER.debug("As the backup descriptor was not found, the backup integrity check was not done.");
        return false;
    }

    public Path getBackupDestDir(Path muleLocation) {
        return muleLocation.resolve(this.upgradeConfigService.getBackupFolderName());
    }

    private Path getBackupDescriptorPathForDistro(Path muleDistroHome) {
        return muleDistroHome.resolve(this.getBackupDestDir(muleDistroHome)).resolve(this.getBackupDescriptorPath());
    }

    private void purgeBackupDir(Path muleLocation, boolean isDryRunMode) throws IOException {
        File backupDestDir = this.getBackupDestDir(muleLocation).toFile();
        if (backupDestDir.exists()) {
            LOGGER.debug("Deleting backup folder at: {}", (Object)backupDestDir);
            if (!isDryRunMode) {
                FileUtils.forceDelete((File)backupDestDir);
            }
        }
        if (!isDryRunMode) {
            this.createBackupDirectory(backupDestDir);
        }
    }

    private void createBackupDirectory(File backupDestDir) throws IOException {
        backupDestDir.mkdirs();
        if (this.fileSystemService.isWindowsOs()) {
            Files.setAttribute(backupDestDir.toPath(), "dos:hidden", true, new LinkOption[0]);
        }
    }

    public void printBackUpDescriptor(Optional<BackupDescriptor> backupDescriptor) {
        if (backupDescriptor.isPresent()) {
            String backupDescriptorPrettyFormatted = String.format("%n%s", PrettyPrintingFormatter.formatBackupDescriptor((BackupDescriptor)backupDescriptor.get()));
            LOGGER.info(backupDescriptorPrettyFormatted);
        }
    }

    private void generateDescriptor(MuleDistribution muleDistribution, Path backupPath, boolean isDryRunMode) throws IOException {
        String muleVersion = muleDistribution.getVersion().toString();
        Path muleLocation = muleDistribution.getLocation();
        BackupDescriptor backupDescriptor = BackupDescriptor.builder().backupGenerationTimestamp(Instant.now(this.getClock())).upgradeToolVersion(this.appService.getVersion()).muleRuntimeDistributionVersion(muleVersion).backupEntries(this.descriptorService.getEntriesInPath(backupPath)).build();
        File yamlDescriptor = this.getBackupDescriptorPathForDistro(muleLocation).toFile();
        if (!isDryRunMode) {
            this.yamlService.writeValueToFile(yamlDescriptor, (Object)backupDescriptor);
        }
    }

    private Path getBackupDescriptorPath() {
        return Paths.get(this.upgradeConfigService.getBackupDescriptorFileName(), new String[0]);
    }

    private void deleteBackupFolder(Path muleHome, boolean isDryRunMode) throws IOException {
        File backupDir = muleHome.resolve(this.upgradeConfigService.getBackupFolderName()).toFile();
        if (backupDir.exists() && !isDryRunMode) {
            FileUtils.forceDelete((File)backupDir);
        }
    }

    public Clock getClock() {
        if (this.clock == null) {
            this.clock = Clock.systemDefaultZone();
        }
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }
}

